/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer.persistence;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.fcrepo.indexer.Indexer;
import org.fcrepo.indexer.persistence.BasePersistenceIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfPersistenceIndexer
extends BasePersistenceIndexer<Model, File> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfPersistenceIndexer.class);
    private final RDFLang rdfLang;

    public RdfPersistenceIndexer(String pathName, String rdfLang, String extension) throws IllegalArgumentException {
        super(pathName, extension);
        this.rdfLang = RDFLang.valueOf(rdfLang);
    }

    @Override
    public Indexer.IndexerType getIndexerType() {
        return Indexer.IndexerType.RDF;
    }

    @Override
    public Callable<File> updateSynch(final URI id, final Model model) {
        if (id.toString().endsWith("/")) {
            throw new IllegalArgumentException("Identifiers for use with this indexer may not end in '/'!");
        }
        return new Callable<File>(){

            @Override
            public File call() throws IOException {
                Path p = RdfPersistenceIndexer.this.pathFor(id);
                FileOutputStream out = new FileOutputStream(p.toFile());
                LOGGER.debug("Updating {} to file: {}", (Object)id, (Object)p.toAbsolutePath().toString());
                model.write((OutputStream)out, RdfPersistenceIndexer.this.rdfLang.toString());
                return p.toFile();
            }
        };
    }

    @Override
    public Callable<File> removeSynch(URI id) {
        LOGGER.debug("Received remove for identifier: {}", (Object)id);
        return this.updateSynch(id, ModelFactory.createDefaultModel());
    }

    static enum RDFLang {
        N3("N3"),
        N_TRIPLES("N-TRIPLE"),
        RDF_XML("RDF/XML"),
        RDF_XML_ABBREV("RDF/XML-ABBREV"),
        TURTLE("TURTLE");

        private final String name;

        private RDFLang(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

