/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer.solr;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.fcrepo.indexer.AsynchIndexer;
import org.fcrepo.indexer.Indexer;
import org.fcrepo.indexer.NamedFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrIndexer
extends AsynchIndexer<NamedFields, UpdateResponse> {
    public static final String CONFIGURATION_FOLDER = "fedora:system/fedora:transform/fedora:ldpath/";
    public static final Long INDEX_TIME_BOOST = 1L;
    private final SolrServer server;
    private static final Integer THREAD_POOL_SIZE = 5;
    private ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(THREAD_POOL_SIZE));
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrIndexer.class);
    private static Maps.EntryTransformer<String, Collection<String>, SolrInputField> collection2solrInputField = new Maps.EntryTransformer<String, Collection<String>, SolrInputField>(){

        public SolrInputField transformEntry(String key, Collection<String> input) {
            SolrInputField field = new SolrInputField(key);
            for (String value : input) {
                LOGGER.debug("Adding value: {} to field: {}", (Object)value, (Object)key);
                field.addValue((Object)value, (float)INDEX_TIME_BOOST.longValue());
            }
            return field;
        }
    };

    @Autowired
    public SolrIndexer(SolrServer solrServer) {
        this.server = solrServer;
    }

    @Override
    public Callable<UpdateResponse> updateSynch(final URI id, final NamedFields fields) {
        LOGGER.debug("Received request for update to: {}", (Object)id);
        return new Callable<UpdateResponse>(){

            @Override
            public UpdateResponse call() {
                try {
                    LOGGER.debug("Executing request to Solr index for identifier: {} with fields: {}", (Object)id, (Object)fields);
                    fields.put("id", Arrays.asList(id.toString()));
                    SolrInputDocument inputDoc = SolrIndexer.this.fromMap(fields);
                    LOGGER.debug("Created SolrInputDocument: {}", (Object)inputDoc);
                    UpdateResponse resp = SolrIndexer.this.server.add(inputDoc);
                    if (resp.getStatus() == 0) {
                        LOGGER.debug("Update request was successful for: {}", (Object)id);
                    } else {
                        LOGGER.error("Update request returned error code: {} for identifier: {}", (Object)resp.getStatus(), (Object)id);
                    }
                    LOGGER.debug("Received result from Solr request.");
                    return resp;
                }
                catch (IOException | SolrServerException e) {
                    LOGGER.error("Update exception: {}!", e);
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    protected SolrInputDocument fromMap(Map<String, Collection<String>> fields) {
        LOGGER.debug("Constructing new SolrInputDocument...");
        return new SolrInputDocument(Maps.transformEntries(fields, collection2solrInputField));
    }

    @Override
    public Callable<UpdateResponse> removeSynch(final URI uri) {
        LOGGER.debug("Received request for removal of: {}", (Object)uri);
        return new Callable<UpdateResponse>(){

            @Override
            public UpdateResponse call() {
                try {
                    UpdateResponse resp = SolrIndexer.this.server.deleteById(uri.toString());
                    if (resp.getStatus() == 0) {
                        LOGGER.debug("Remove request was successful for: {}", (Object)uri);
                        SolrIndexer.this.server.commit();
                    } else {
                        LOGGER.error("Remove request has error, code: {} for uri: {}", (Object)resp.getStatus(), (Object)uri);
                    }
                    return resp;
                }
                catch (IOException | SolrServerException e) {
                    LOGGER.error("Delete Exception: {}", e);
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    @Override
    public Indexer.IndexerType getIndexerType() {
        return Indexer.IndexerType.NAMEDFIELDS;
    }

    @Override
    public ListeningExecutorService executorService() {
        return this.executorService;
    }
}

