/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer.webapp;

import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.indexer.IndexerGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class FedoraIndexer
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexerGroup.class);
    private IndexerGroup indexer;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.indexer = (IndexerGroup)ctx.getBean(sc.getInitParameter("beanName"));
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String message;
        String recurParam = request.getParameter("recursive");
        boolean recursive = recurParam == null || recurParam.equals("true");
        String baseURI = request.getParameter("baseURI");
        try {
            URI uri = new URI(baseURI);
            this.indexer.reindex(uri, recursive);
            message = "Reindexing started";
        }
        catch (NullPointerException ex) {
            message = "Error: the baseURI parameter must be specified";
            response.setStatus(400);
        }
        catch (URISyntaxException ex) {
            message = "Error: the baseURI is invalid";
            response.setStatus(400);
        }
        try {
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.println(message);
        }
        catch (Exception ex) {
            LOGGER.warn("Error sending output");
        }
    }
}

