/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.metrics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.fcrepo.metrics.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterFactory {
    private static final Logger logger = LoggerFactory.getLogger(ReporterFactory.class);

    public GraphiteReporter getGraphiteReporter(String string, Graphite graphite) {
        GraphiteReporter graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)RegistryService.getMetrics()).prefixedWith(string).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
        graphiteReporter.start(1L, TimeUnit.MINUTES);
        logger.debug("Started GraphiteReporter");
        return graphiteReporter;
    }

    public JmxReporter getJmxReporter(String string) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)RegistryService.getMetrics()).registerWith(mBeanServer).inDomain("org.fcrepo").convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).build();
        jmxReporter.start();
        logger.debug("Started JmxReporter");
        return jmxReporter;
    }
}

