/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.metrics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.net.InetSocketAddress;
import org.fcrepo.metrics.ReporterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class MetricsConfig {
    @Bean
    public ReporterFactory reporterFactory() {
        return new ReporterFactory();
    }

    @Configuration
    @Profile(value={"metrics", "metrics.jmx"})
    public static class JmxConfig {
        String prefix = System.getProperty("fcrepo.metrics.prefix", "org.fcrepo");

        @Bean
        public JmxReporter jmxReporter() {
            MetricsConfig cfg = new MetricsConfig();
            return cfg.reporterFactory().getJmxReporter(this.prefix);
        }
    }

    @Configuration
    @Profile(value={"metrics", "metrics.graphite"})
    public static class GraphiteConfig {
        @Bean
        public Graphite graphiteClient() {
            String hostname = System.getProperty("fcrepo.metrics.host", "localhost");
            int port = Integer.parseInt(System.getProperty("fcrepo.metrics.port", "2003"));
            return new Graphite(new InetSocketAddress(hostname, port));
        }

        @Bean
        public GraphiteReporter graphiteReporter() {
            MetricsConfig cfg = new MetricsConfig();
            String prefix = System.getProperty("fcrepo.metrics.prefix", "org.fcrepo");
            return cfg.reporterFactory().getGraphiteReporter(prefix, this.graphiteClient());
        }
    }
}

