/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.metrics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.fcrepo.metrics.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterFactory {
    private static final Logger logger = LoggerFactory.getLogger(ReporterFactory.class);

    public GraphiteReporter getGraphiteReporter(String prefix, Graphite g) {
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)RegistryService.getMetrics()).prefixedWith(prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(g);
        reporter.start(1L, TimeUnit.MINUTES);
        logger.debug("Started GraphiteReporter");
        return reporter;
    }

    public JmxReporter getJmxReporter(String prefix) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)RegistryService.getMetrics()).registerWith(mbs).inDomain("org.fcrepo").convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).build();
        reporter.start();
        logger.debug("Started JmxReporter");
        return reporter;
    }
}

