/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.io.PrintStream;

public class RegistryService {
    private static final MetricRegistry METRICS = SharedMetricRegistries.getOrCreate((String)"fcrepo-metrics");
    private static volatile RegistryService instance = null;

    private RegistryService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegistryService getInstance() {
        RegistryService local = instance;
        if (null == local) {
            MetricRegistry metricRegistry = METRICS;
            synchronized (metricRegistry) {
                local = instance;
                if (null == local) {
                    instance = local = new RegistryService();
                }
            }
        }
        return local;
    }

    public MetricRegistry getMetrics() {
        return METRICS;
    }

    public void dumpMetrics(PrintStream os) {
        MetricRegistry registry = this.getMetrics();
        MetricFilter filter = MetricFilter.ALL;
        ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)registry).build();
        reporter.report(registry.getGauges(filter), registry.getCounters(filter), registry.getHistograms(filter), registry.getMeters(filter), registry.getTimers(filter));
    }
}

