/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fcrepo.migration.validator.api.ObjectReportSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationResultsSummary {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationResultsSummary.class);
    private final Map<String, ObjectReportSummary> objectReports = new HashMap<String, ObjectReportSummary>();
    private ObjectReportSummary repositoryReport;

    public void addObjectReport(String objectId, ObjectReportSummary objectReportSummary) {
        if (this.containsReport(objectId)) {
            throw new IllegalArgumentException("Should not be overwriting existing report: " + objectId);
        }
        LOGGER.debug("Adding report for object: {}, {}", (Object)objectId, (Object)objectReportSummary.getReportFilename());
        this.objectReports.put(objectId, objectReportSummary);
    }

    public boolean containsReport(String objectId) {
        return this.objectReports.containsKey(objectId);
    }

    public Collection<ObjectReportSummary> getObjectReports() {
        return this.objectReports.values();
    }

    public void addRepositoryReport(ObjectReportSummary repositoryReport) {
        this.repositoryReport = repositoryReport;
    }

    public ObjectReportSummary getRepositoryReport() {
        return this.repositoryReport;
    }
}

