/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import edu.wisc.library.ocfl.api.OcflRepository;
import java.util.List;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.ValidationResultWriter;
import org.fcrepo.migration.validator.api.ValidationTask;
import org.fcrepo.migration.validator.impl.F3RepositoryValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class F3RepositoryValidationTask
extends ValidationTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(F3RepositoryValidationTask.class);
    private final long numObjects;
    private final boolean checkNumObjects;
    private final OcflRepository ocflRepository;
    private final ValidationResultWriter writer;

    public F3RepositoryValidationTask(boolean checkNumObjects, long numObjects, OcflRepository ocflRepository, ValidationResultWriter writer) {
        this.writer = writer;
        this.numObjects = numObjects;
        this.ocflRepository = ocflRepository;
        this.checkNumObjects = checkNumObjects;
    }

    @Override
    public void run() {
        LOGGER.info("starting repository processor");
        F3RepositoryValidator repositoryValidator = new F3RepositoryValidator(this.checkNumObjects, this.numObjects);
        List<ValidationResult> results = repositoryValidator.validate(this.ocflRepository);
        this.writer.write(results);
    }
}

