/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import edu.wisc.library.ocfl.api.OcflRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.fcrepo.migration.validator.api.RepositoryValidator;
import org.fcrepo.migration.validator.api.ValidationResult;

public class F3RepositoryValidator
implements RepositoryValidator {
    private final boolean enableCheckNumObjects;
    private final AtomicInteger index;
    private final long numObjectsF3;
    private final List<ValidationResult> validationResults = new ArrayList<ValidationResult>();

    public F3RepositoryValidator(boolean enableCheckNumObjects, long numObjects) {
        this.numObjectsF3 = numObjects;
        this.index = new AtomicInteger(0);
        this.enableCheckNumObjects = enableCheckNumObjects;
    }

    @Override
    public List<ValidationResult> validate(OcflRepository repository) {
        if (this.enableCheckNumObjects) {
            this.checkObjects(repository);
        }
        return this.validationResults;
    }

    private void checkObjects(OcflRepository ocflRepository) {
        String success = "Repository object counts match: Total=%s";
        String error = "Repository object counts do not match: sourceValue=%s, targetValue=%s";
        try (Stream ocflIds = ocflRepository.listObjectIds();){
            long ocflCount = ocflIds.count();
            ValidationResult result = ocflCount == this.numObjectsF3 ? new ValidationResult(this.index.getAndIncrement(), ValidationResult.Status.OK, ValidationResult.ValidationLevel.REPOSITORY, ValidationResult.ValidationType.REPOSITORY_RESOURCE_COUNT, String.format("Repository object counts match: Total=%s", this.numObjectsF3)) : new ValidationResult(this.index.getAndIncrement(), ValidationResult.Status.FAIL, ValidationResult.ValidationLevel.REPOSITORY, ValidationResult.ValidationType.REPOSITORY_RESOURCE_COUNT, String.format("Repository object counts do not match: sourceValue=%s, targetValue=%s", this.numObjectsF3, ocflCount));
            this.validationResults.add(result);
        }
    }
}

