/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;

public enum F6DigestAlgorithm {
    sha256(DigestAlgorithm.sha256.getJavaStandardName(), Hashing.sha256()),
    sha512(DigestAlgorithm.sha512.getJavaStandardName(), Hashing.sha512());

    private final String name;
    private final HashFunction hashFunction;

    private F6DigestAlgorithm(String name, HashFunction hashFunction) {
        this.name = name;
        this.hashFunction = hashFunction;
    }

    public String getName() {
        return this.name;
    }

    public String getOcflUrn() {
        return "urn:" + this.name;
    }

    public Hasher hasher() {
        return this.hashFunction.newHasher();
    }
}

