/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import edu.wisc.library.ocfl.api.OcflRepository;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.ObjectSource;
import org.fcrepo.migration.validator.api.ObjectValidationConfig;
import org.fcrepo.migration.validator.api.ValidationExecutionManager;
import org.fcrepo.migration.validator.api.ValidationResultWriter;
import org.fcrepo.migration.validator.api.ValidationTask;
import org.fcrepo.migration.validator.impl.ApplicationConfigurationHelper;
import org.fcrepo.migration.validator.impl.F3ObjectValidationTask;
import org.fcrepo.migration.validator.impl.F3ObjectValidationTaskBuilder;
import org.fcrepo.migration.validator.impl.F3RepositoryValidationTask;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fedora3ValidationExecutionManager
implements ValidationExecutionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fedora3ValidationExecutionManager.class);
    private final ExecutorService executorService;
    private final OcflObjectSessionFactory ocflObjectSessionFactory;
    private final ValidationResultWriter writer;
    private final ObjectSource source;
    private final Set<String> objectsToValidate;
    private final AtomicLong count;
    private final Object lock;
    private final ObjectValidationConfig objectValidationConfig;
    private final ApplicationConfigurationHelper config;

    public Fedora3ValidationExecutionManager(ApplicationConfigurationHelper config) {
        this.config = config;
        this.source = config.objectSource();
        this.writer = config.validationResultWriter();
        this.objectsToValidate = config.readObjectsToValidate();
        this.ocflObjectSessionFactory = config.ocflObjectSessionFactory();
        this.executorService = Executors.newFixedThreadPool(config.getThreadCount());
        this.count = new AtomicLong(0L);
        this.lock = new Object();
        this.objectValidationConfig = config.getObjectValidationConfig();
    }

    @Override
    public void doValidation() {
        try {
            long numObjects = 0L;
            for (FedoraObjectProcessor objectProcessor : this.source) {
                ++numObjects;
                String sourceObjectId = objectProcessor.getObjectInfo().getPid();
                if (!this.objectsToValidate.isEmpty() && !this.objectsToValidate.contains(sourceObjectId)) continue;
                F3ObjectValidationTask task = (F3ObjectValidationTask)new F3ObjectValidationTaskBuilder().processor(objectProcessor).withValidationConfig(this.objectValidationConfig).writer(this.writer).objectSessionFactory(this.ocflObjectSessionFactory).build();
                this.submit(task);
            }
            OcflRepository repository = this.config.ocflRepository();
            boolean checkNumObjects = this.config.checkNumObjects() != false && this.objectsToValidate.isEmpty();
            F3RepositoryValidationTask repositoryTask = new F3RepositoryValidationTask(checkNumObjects, numObjects, repository, this.writer);
            this.submit(repositoryTask);
            this.awaitCompletion();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.shutdown();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void submit(ValidationTask task) {
        this.executorService.submit(() -> {
            try {
                task.run();
            }
            catch (Exception ex) {
                LOGGER.error("validation task failed {}", (Object)ex.getMessage(), (Object)ex);
            }
            finally {
                this.count.decrementAndGet();
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
        });
        this.count.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitCompletion() throws InterruptedException {
        if (this.count.get() == 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.count.get() > 0L) {
                this.lock.wait();
            }
        }
    }

    private void shutdown() throws InterruptedException {
        this.executorService.shutdown();
        if (!this.executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
            LOGGER.error("Failed to shutdown executor service cleanly after 1 minute of waiting");
            this.executorService.shutdownNow();
        }
    }
}

