/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import org.fcrepo.migration.ObjectProperty;

public enum F3State {
    DELETED,
    INACTIVE,
    ACTIVE;


    public static F3State fromString(String state) {
        switch (state.toUpperCase()) {
            case "A": 
            case "ACTIVE": {
                return ACTIVE;
            }
            case "D": 
            case "DELETED": {
                return DELETED;
            }
            case "I": 
            case "INACTIVE": {
                return INACTIVE;
            }
        }
        throw new IllegalArgumentException("Invalid Fedora 3 state");
    }

    public static F3State fromProperty(ObjectProperty property) {
        return F3State.fromString(property.getValue());
    }

    public boolean isDeleted(boolean deleteInactive) {
        return this == DELETED || deleteInactive && this == INACTIVE;
    }
}

