/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.report;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.fcrepo.migration.validator.api.ObjectReportSummary;
import org.fcrepo.migration.validator.api.ObjectValidationResults;
import org.fcrepo.migration.validator.api.ReportHandler;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.ValidationResultsSummary;

public class HtmlReportHandler
implements ReportHandler {
    private final File outputDir;
    private final Configuration config;
    private ValidationResultsSummary validationSummary;

    public HtmlReportHandler(Path outputDir) {
        this.outputDir = outputDir.toFile();
        this.config = new Configuration(Configuration.VERSION_2_3_30);
        this.outputDir.mkdirs();
        this.config.setClassLoaderForTemplateLoading(this.getClass().getClassLoader(), "/templates");
        this.config.setDefaultEncoding("UTF-8");
        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.config.setLogTemplateExceptions(false);
        this.config.setWrapUncheckedExceptions(true);
        this.config.setFallbackOnNullLoopVariable(false);
    }

    @Override
    public void beginReport() {
    }

    @Override
    public String objectLevelReport(ObjectValidationResults objectValidationResults) {
        String id = objectValidationResults.getObjectId();
        String filename = id + ".html";
        List<ValidationResult> success = objectValidationResults.getPassed();
        List<ValidationResult> errors = objectValidationResults.getErrors();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", id);
        data.put("success", success);
        data.put("successCount", success.size());
        data.put("errors", errors);
        data.put("errorCount", errors.size());
        try {
            Template template = this.config.getTemplate("object.ftl");
            File file = new File(this.outputDir, filename);
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            template.process(data, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
        return filename;
    }

    @Override
    public String repositoryLevelReport(ObjectValidationResults objectValidationResults) {
        String filename = "repository.html";
        try {
            Template template = this.config.getTemplate("repository.ftl");
            File file = new File(this.outputDir, "repository.html");
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            template.process(null, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
        return "repository.html";
    }

    @Override
    public String validationSummary(ValidationResultsSummary validationSummary) {
        String reportFilename = "index.html";
        if (validationSummary == null) {
            throw new NullPointerException("Unable to process end of report without a 'validationSummary'");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd, HH:mm:ss z");
        List errors = validationSummary.getObjectReports().stream().filter(ObjectReportSummary::hasErrors).collect(Collectors.toList());
        data.put("date", format.format(new Date()));
        data.put("objectCount", validationSummary.getObjectReports().size());
        data.put("objects", validationSummary.getObjectReports());
        data.put("errors", errors);
        data.put("errorCount", errors.size());
        try {
            Template template = this.config.getTemplate("summary.ftl");
            FileWriter writer = new FileWriter(new File(this.outputDir, "index.html"));
            template.process(data, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
        return "index.html";
    }

    @Override
    public void endReport() {
    }
}

