/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.api;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.fcrepo.migration.validator.report.ReportType;

public abstract class ValidationConfig {
    private int threadCount = 1;
    private Path resultsDirectory;
    private File ocflRepositoryRootDirectory;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setResultsDirectory(Path resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    public Path getResultsDirectory() {
        return this.resultsDirectory;
    }

    public Path getReportDirectory(ReportType reportType) {
        switch (reportType) {
            case csv: {
                return this.getResultsDirectory().resolve("csv");
            }
            case tsv: {
                return this.getResultsDirectory().resolve("tsv");
            }
            case html: {
                return this.getResultsDirectory().resolve("html");
            }
        }
        throw new IllegalArgumentException("Unknown report type: " + reportType);
    }

    public Path getJsonOutputDirectory() {
        return this.getResultsDirectory().resolve("json");
    }

    public File getOcflRepositoryRootDirectory() {
        return this.ocflRepositoryRootDirectory;
    }

    public void setOcflRepositoryRootDirectory(File ocflRepositoryRootDirectory) {
        this.ocflRepositoryRootDirectory = ocflRepositoryRootDirectory;
    }
}

