/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ValidationResult {
    private int index;
    @JsonProperty
    private Status status;
    @JsonProperty
    private ValidationLevel validationLevel;
    @JsonProperty
    private ValidationType validationType;
    @JsonProperty
    private String details;
    @JsonProperty
    private String sourceObjectId;
    @JsonProperty
    private String targetObjectId;
    @JsonProperty
    private String sourceResourceId;
    @JsonProperty
    private String targetResourceId;

    public ValidationResult(int index, Status status, ValidationLevel validationLevel, ValidationType validationType, String details) {
        this(index, status, validationLevel, validationType, null, null, details);
    }

    public ValidationResult(int index, Status status, ValidationLevel validationLevel, ValidationType validationType, String sourceObjectId, String targetObjectId, String details) {
        this(index, status, validationLevel, validationType, sourceObjectId, targetObjectId, null, null, details);
    }

    public ValidationResult(int index, Status status, ValidationLevel validationLevel, ValidationType validationType, String sourceObjectId, String targetObjectId, String sourceResourceId, String targetResourceId, String details) {
        this.index = index;
        this.status = status;
        this.validationLevel = validationLevel;
        this.validationType = validationType;
        this.sourceObjectId = sourceObjectId;
        this.targetObjectId = targetObjectId;
        this.sourceResourceId = sourceResourceId;
        this.targetResourceId = targetResourceId;
        this.details = details;
    }

    public ValidationResult() {
    }

    public int getIndex() {
        return this.index;
    }

    public Status getStatus() {
        return this.status;
    }

    public ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    public ValidationType getValidationType() {
        return this.validationType;
    }

    public String getDetails() {
        return this.details;
    }

    public String getSourceObjectId() {
        return this.sourceObjectId;
    }

    public String getTargetObjectId() {
        return this.targetObjectId;
    }

    public String getSourceResourceId() {
        return this.sourceResourceId;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static enum ValidationType {
        OBJECT_READABLE,
        SOURCE_OBJECT_DELETED,
        SOURCE_OBJECT_EXISTS_IN_TARGET,
        TARGET_OBJECT_EXISTS_IN_SOURCE,
        SOURCE_OBJECT_RESOURCE_DELETED,
        SOURCE_OBJECT_RESOURCE_EXISTS_IN_TARGET,
        TARGET_OBJECT_RESOURCE_EXISTS_IN_SOURCE,
        METADATA,
        BINARY_SIZE,
        BINARY_CHECKSUM,
        BINARY_VERSION_COUNT,
        BINARY_HEAD_COUNT,
        BINARY_METADATA,
        REPOSITORY_RESOURCE_COUNT;

    }

    public static enum ValidationLevel {
        REPOSITORY,
        OBJECT,
        OBJECT_RESOURCE;

    }

    public static enum Status {
        OK,
        FAIL;

    }
}

