/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.List;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.ValidationResultWriter;
import org.fcrepo.migration.validator.impl.ValidationResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemValidationResultWriter
implements ValidationResultWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemValidationResultWriter.class);
    private Path validationRoot;

    public FileSystemValidationResultWriter(Path validationRoot) {
        this.validationRoot = validationRoot;
        this.validationRoot.toFile().mkdirs();
    }

    @Override
    public void write(List<ValidationResult> results) {
        ObjectMapper objectMapper = new ObjectMapper();
        for (ValidationResult result : results) {
            LOGGER.info("Writing of results here: {}", (Object)result);
            Path jsonFilePath = this.validationRoot.resolve(ValidationResultUtils.resolvePathToJsonResult(result));
            File file = jsonFilePath.toFile();
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                String resultStr = objectMapper.writeValueAsString((Object)result);
                writer.write(resultStr);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

