/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import com.google.common.collect.Sets;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import edu.wisc.library.ocfl.api.OcflRepository;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.fcrepo.migration.DatastreamInfo;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectProperty;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.ObjectVersionReference;
import org.fcrepo.migration.validator.api.ObjectValidationConfig;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.impl.F3ControlGroup;
import org.fcrepo.migration.validator.impl.F3State;
import org.fcrepo.migration.validator.impl.F6DigestAlgorithm;
import org.fcrepo.migration.validator.impl.Fedora3ObjectValidator;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatingObjectHandler
implements FedoraObjectVersionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fedora3ObjectValidator.class);
    private static final DateTimeFormatter ISO_8601 = DateTimeFormatter.ISO_INSTANT;
    public static final String F3_LABEL = "info:fedora/fedora-system:def/model#label";
    public static final String F3_STATE = "info:fedora/fedora-system:def/model#state";
    public static final String F3_CREATED_DATE = "info:fedora/fedora-system:def/model#createdDate";
    public static final String F3_LAST_MODIFIED_DATE = "info:fedora/fedora-system:def/view#lastModifiedDate";
    public static final String F3_OWNER_ID = "info:fedora/fedora-system:def/model#ownerId";
    private static final String RELS_INT = "RELS-INT";
    private static final String DOWNLOAD_NAME_PROP = "info:fedora/fedora-system:def/model#downloadFilename";
    private static final String RELS_DELETED_ENTRY = "FCREPO_MIGRATION_VALIDATOR_DELETED_ENTRY";
    private F3State objectState;
    private ObjectInfo objectInfo;
    private final boolean checksum;
    private final boolean deleteInactive;
    private final boolean validateHeadOnly;
    private final Path ocflRoot;
    private final OcflRepository repository;
    private final OcflObjectSession ocflSession;
    private final List<ValidationResult> validationResults = new ArrayList<ValidationResult>();
    private int indexCounter;
    private final Set<String> headDatastreamIds = new HashSet<String>();
    private final F6DigestAlgorithm digestAlgorithm;
    private final Map<String, List<String>> relsFilenames = new HashMap<String, List<String>>();
    private static final Map<String, PropertyResolver> OCFL_PROPERTY_RESOLVERS = Map.of("info:fedora/fedora-system:def/model#label", headers -> Optional.empty(), "info:fedora/fedora-system:def/model#state", headers -> Optional.empty(), "info:fedora/fedora-system:def/model#ownerId", headers -> Optional.empty(), "info:fedora/fedora-system:def/model#createdDate", headers -> Optional.of(headers.getCreatedDate().toString()), "info:fedora/fedora-system:def/view#lastModifiedDate", headers -> Optional.of(headers.getLastModifiedDate().toString()));

    public void processObjectVersions(Iterable<ObjectVersionReference> iterable, ObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
        Iterator<ObjectVersionReference> referenceIterator = iterable.iterator();
        if (referenceIterator.hasNext()) {
            ObjectReference objectReference = referenceIterator.next().getObject();
            LOGGER.debug("beginning processing on object: pid={}", (Object)objectInfo);
            if (this.initialObjectValidation(objectReference.getObjectProperties())) {
                this.preprocessRelsInt(objectReference);
                objectReference.listDatastreamIds().forEach(dsId -> this.validateDatastream((String)dsId, objectReference));
                this.completeObjectValidation();
            }
        }
    }

    private void preprocessRelsInt(ObjectReference objectReference) {
        String pid = this.objectInfo.getPid();
        HashMap filenameMap = new HashMap();
        List dsVersions = Optional.ofNullable(objectReference.getDatastreamVersions(RELS_INT)).orElse(List.of());
        for (DatastreamVersion dsVersion : dsVersions) {
            Model rdf = this.parseRdf(dsVersion);
            Map<String, Model> models = this.splitRelsInt(rdf);
            HashSet oldIds = new HashSet(filenameMap.keySet());
            filenameMap.clear();
            models.forEach((id, model) -> model.listStatements().forEach(statement -> {
                if (DOWNLOAD_NAME_PROP.equals(statement.getPredicate().getURI())) {
                    LOGGER.trace("{} has download prop for {}", (Object)pid, id);
                    String filename = statement.getObject().toString();
                    List prevFilenames = this.relsFilenames.computeIfAbsent((String)id, ignored -> new ArrayList<String>(List.of(filename)));
                    if (!((String)prevFilenames.get(prevFilenames.size() - 1)).equals(filename)) {
                        prevFilenames.add(filename);
                    }
                    filenameMap.put(id, statement.getObject().toString());
                }
            }));
            Sets.SetView deleted = Sets.difference(oldIds, filenameMap.keySet());
            deleted.forEach(id -> {
                LOGGER.trace("{} has a deleted download prop for {}", (Object)pid, id);
                this.relsFilenames.get(id).add(RELS_DELETED_ENTRY);
            });
        }
    }

    public ValidatingObjectHandler(OcflObjectSession session, ObjectValidationConfig config) {
        this.ocflSession = session;
        this.checksum = config.isChecksum();
        this.ocflRoot = config.getOcflRoot();
        this.repository = config.getOcflRepository();
        this.deleteInactive = config.deleteInactive();
        this.digestAlgorithm = config.getDigestAlgorithm();
        this.validateHeadOnly = config.isValidateHeadOnly();
    }

    public List<ValidationResult> getValidationResults() {
        return this.validationResults;
    }

    private boolean initialObjectValidation(ObjectProperties objectProperties) {
        ResourceHeaders headers;
        String pid = this.objectInfo.getPid();
        String ocflId = this.ocflSession.ocflObjectId();
        Model model = ModelFactory.createDefaultModel();
        try {
            headers = this.ocflSession.readHeaders(ocflId);
            this.ocflSession.readContent(ocflId).getContentStream().ifPresent(is -> RDFDataMgr.read((Model)model, (InputStream)is, (Lang)RDFFormat.NTRIPLES.getLang()));
            this.validationResults.add(new ValidationResult(this.indexCounter++, ValidationResult.Status.OK, ValidationResult.ValidationLevel.OBJECT, ValidationResult.ValidationType.SOURCE_OBJECT_EXISTS_IN_TARGET, pid, ocflId, "Source object is present in target repository."));
        }
        catch (NotFoundException ex) {
            this.validationResults.add(new ValidationResult(this.indexCounter++, ValidationResult.Status.FAIL, ValidationResult.ValidationLevel.OBJECT, ValidationResult.ValidationType.SOURCE_OBJECT_EXISTS_IN_TARGET, pid, ocflId, "Source object not present in target repository."));
            return false;
        }
        List properties = objectProperties.listProperties();
        ObjectProperty stateProperty = properties.stream().filter(p -> p.getName().equals(F3_STATE)).findFirst().orElseThrow(() -> new IllegalStateException("Could not find info:fedora/fedora-system:def/model#stateon object" + ocflId));
        this.objectState = F3State.fromProperty(stateProperty);
        ValidationResultBuilder builder = new ValidationResultBuilder(pid, ocflId, null, null, ValidationResult.ValidationLevel.OBJECT);
        if (this.objectState.isDeleted(this.deleteInactive)) {
            String success = "pid: %s -> object deleted states match: source=%s, target=%s";
            String error = "pid: %s -> object deleted states do not match: source=%s, target=%s";
            ValidationResult deletedResult = headers.isDeleted() ? builder.ok(ValidationResult.ValidationType.SOURCE_OBJECT_DELETED, String.format("pid: %s -> object deleted states match: source=%s, target=%s", new Object[]{pid, this.objectState, true})) : builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_DELETED, String.format("pid: %s -> object deleted states do not match: source=%s, target=%s", new Object[]{pid, this.objectState, false}));
            this.validationResults.add(deletedResult);
        } else {
            properties.forEach(op -> this.validateObjectProperty((ObjectProperty)op, headers, model, builder));
        }
        return true;
    }

    private void validateObjectProperty(ObjectProperty op, ResourceHeaders headers, Model model, ValidationResultBuilder builder) {
        String pid = this.objectInfo.getPid();
        String ocflId = this.ocflSession.ocflObjectId();
        String property = op.getName();
        String sourceValue = op.getValue();
        LOGGER.info("PID = {}, object property: name = {}, value = {}", new Object[]{pid, property, sourceValue});
        PropertyResolver resolver = OCFL_PROPERTY_RESOLVERS.get(property);
        if (resolver != null) {
            String success = "pid: %s -> properties match: f3 prop name=%s, source=%s, target=%s";
            String error = "pid: %s -> properties do not match: f3 prop name=%s, source=%s, target=%s";
            String notFound = "pid: %s -> property not found in OCFL: f3 prop name=%s, source=%s";
            ValidationResult result = resolver.resolve(headers).or(() -> resolver.fromModel(model, ocflId, property)).map(targetVal -> resolver.equals(sourceValue, (String)targetVal) ? builder.ok(ValidationResult.ValidationType.METADATA, String.format("pid: %s -> properties match: f3 prop name=%s, source=%s, target=%s", pid, property, sourceValue, targetVal)) : builder.fail(ValidationResult.ValidationType.METADATA, String.format("pid: %s -> properties do not match: f3 prop name=%s, source=%s, target=%s", pid, property, sourceValue, targetVal))).orElse(builder.fail(ValidationResult.ValidationType.METADATA, String.format("pid: %s -> property not found in OCFL: f3 prop name=%s, source=%s", pid, property, sourceValue)));
            this.validationResults.add(result);
        }
    }

    public void validateDatastream(String dsId, ObjectReference objectReference) {
        List dsVersions = objectReference.getDatastreamVersions(dsId);
        String sourceObjectId = this.objectInfo.getPid();
        String targetObjectId = this.ocflSession.ocflObjectId();
        String sourceResource = sourceObjectId + "/" + dsId;
        String targetResource = targetObjectId + "/" + dsId;
        List targetVersions = this.ocflSession.listVersions(targetResource);
        ValidationResultBuilder builder = new ValidationResultBuilder(sourceObjectId, targetObjectId, sourceResource, targetResource, ValidationResult.ValidationLevel.OBJECT_RESOURCE);
        int sourceVersionCount = 0;
        int sourceDeletedCount = 0;
        String sourceCreated = null;
        Optional<List<String>> downloadFilenames = Optional.ofNullable(this.relsFilenames.get(sourceResource));
        int softVersionCount = downloadFilenames.map(filenames -> this.searchSoftVersions(sourceResource, targetVersions, (List<String>)filenames)).orElse(0);
        for (DatastreamVersion dsVersion : dsVersions) {
            int currentVersion;
            Object version;
            boolean isHead;
            DatastreamInfo dsInfo = dsVersion.getDatastreamInfo();
            if (sourceCreated == null) {
                sourceCreated = dsVersion.getCreated();
            }
            if (isHead = dsVersion.isLastVersionIn(objectReference)) {
                version = "HEAD";
                this.headDatastreamIds.add(dsId);
                currentVersion = sourceVersionCount + softVersionCount;
            } else {
                version = "version " + sourceVersionCount;
                currentVersion = sourceVersionCount;
            }
            try {
                OcflVersionInfo ocflVersionInfo = (OcflVersionInfo)targetVersions.get(currentVersion + sourceDeletedCount);
                ObjectVersionId objectVersionId = ObjectVersionId.version((String)ocflVersionInfo.getOcflObjectId(), (String)ocflVersionInfo.getVersionNumber());
                ResourceHeaders headers = this.ocflSession.readHeaders(targetResource, ocflVersionInfo.getVersionNumber());
                OcflObjectVersion ocflObject = this.repository.getObject(objectVersionId);
                if (isHead || !this.validateHeadOnly) {
                    this.validateSize(dsVersion, headers, ocflObject, (String)version, builder);
                    this.validateCreatedDate(sourceCreated, headers, (String)version, builder);
                    this.validateLastModified(dsVersion, headers, (String)version, builder);
                    this.validateChecksum(dsVersion, headers, (String)version, builder);
                }
            }
            catch (IndexOutOfBoundsException | NotFoundException ex) {
                String error = "Source object resource does not exist in target for source version=%d";
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_EXISTS_IN_TARGET, String.format("Source object resource does not exist in target for source version=%d", currentVersion)));
            }
            F3State state = F3State.fromString(dsInfo.getState());
            if (state.isDeleted(this.deleteInactive) || isHead && this.objectState.isDeleted(this.deleteInactive)) {
                ++sourceDeletedCount;
                this.headDatastreamIds.remove(dsId);
                this.validateDeleted(targetResource, currentVersion, targetVersions, builder);
            }
            ++sourceVersionCount;
        }
        String versionSuccess = "binary version counts match for resource: source=%d, RELS-INT=%d, target=%d";
        String versionFailure = "binary version counts do not match for resource: source=%d, RELS-INT=%d, target=%d";
        int f3VersionCount = sourceVersionCount + softVersionCount;
        int targetVersionCount = targetVersions.size() - sourceDeletedCount;
        if (f3VersionCount == targetVersionCount) {
            String details = String.format("binary version counts match for resource: source=%d, RELS-INT=%d, target=%d", sourceVersionCount, softVersionCount, targetVersionCount);
            this.validationResults.add(builder.ok(ValidationResult.ValidationType.BINARY_VERSION_COUNT, details));
        } else {
            String details = String.format("binary version counts do not match for resource: source=%d, RELS-INT=%d, target=%d", sourceVersionCount, softVersionCount, targetVersionCount);
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_VERSION_COUNT, details));
        }
    }

    private int searchSoftVersions(String sourceResource, List<OcflVersionInfo> targetVersions, List<String> filenames) {
        int transitions = 0;
        for (OcflVersionInfo targetVersion : targetVersions) {
            ResourceHeaders headers;
            if (filenames.isEmpty()) break;
            String f3Filename = filenames.remove(0);
            if (f3Filename.equals((headers = this.ocflSession.readHeaders(targetVersion.getResourceId(), targetVersion.getVersionNumber())).getFilename())) continue;
            LOGGER.debug("{} has filename update {} -> {}", new Object[]{sourceResource, headers.getFilename(), f3Filename});
            ++transitions;
        }
        return transitions;
    }

    private Model parseRdf(DatastreamVersion dv) {
        Model model;
        block8: {
            Model model2 = ModelFactory.createDefaultModel();
            InputStream is = dv.getContent();
            try {
                RDFDataMgr.read((Model)model2, (InputStream)is, (Lang)Lang.RDFXML);
                model = model2;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse RDF XML", e);
                }
            }
            is.close();
        }
        return model;
    }

    private Map<String, Model> splitRelsInt(Model relsIntModel) {
        String infoFedora = "info:fedora/";
        HashMap<String, Model> splitModels = new HashMap<String, Model>();
        StmtIterator it = relsIntModel.listStatements();
        while (it.hasNext()) {
            Statement statement = (Statement)it.next();
            String uri = statement.getSubject().getURI();
            String id = uri.startsWith("info:fedora/") ? uri.substring("info:fedora/".length()) : uri;
            Model model = splitModels.computeIfAbsent(id, k -> ModelFactory.createDefaultModel());
            model.add(statement);
        }
        return splitModels;
    }

    private void validateDeleted(String resource, int sourceVersionCount, List<OcflVersionInfo> versions, ValidationResultBuilder builder) {
        String version = "version " + sourceVersionCount;
        String success = "%s is marked as deleted";
        String failure = "%s is not marked as deleted in Fedora 6 OCFL";
        String error = "Deleted object for %s does not exist in Fedora 6 OCFL";
        try {
            OcflVersionInfo versionInfo = versions.get(sourceVersionCount + 1);
            ResourceHeaders headers = this.ocflSession.readHeaders(resource, versionInfo.getVersionNumber());
            if (headers.isDeleted()) {
                this.validationResults.add(builder.ok(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_DELETED, String.format("%s is marked as deleted", version)));
            } else {
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_DELETED, String.format("%s is not marked as deleted in Fedora 6 OCFL", version)));
            }
        }
        catch (IndexOutOfBoundsException | NotFoundException ex) {
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_DELETED, String.format("Deleted object for %s does not exist in Fedora 6 OCFL", version)));
        }
    }

    private void validateChecksum(DatastreamVersion dsVersion, ResourceHeaders headers, String version, ValidationResultBuilder builder) {
        String success = "%s binary checksums match: %s";
        String error = "%s binary checksums do no match: sourceValue=%s, targetValue=%s";
        String notFound = "%s binary checksum not found in Fedora 6 headers";
        String exception = "%s binary checksum was unable to be calculated: exception=%s";
        F3ControlGroup controlGroup = F3ControlGroup.fromString(dsVersion.getDatastreamInfo().getControlGroup());
        if (this.checksum && controlGroup == F3ControlGroup.MANAGED) {
            HashCode sourceHash;
            try {
                Hasher hasher = this.digestAlgorithm.hasher();
                ByteStreams.copy((InputStream)dsVersion.getContent(), (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
                sourceHash = hasher.hash();
            }
            catch (IOException e) {
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_CHECKSUM, String.format("%s binary checksum was unable to be calculated: exception=%s", version, e)));
                return;
            }
            Optional<String> ocflDigest = headers.getDigests().stream().map(URI::toString).filter(uri -> uri.startsWith(this.digestAlgorithm.getOcflUrn())).map(uri -> uri.substring(uri.lastIndexOf(":") + 1)).findFirst();
            String sourceValue = sourceHash.toString();
            ocflDigest.ifPresentOrElse(targetValue -> {
                if (Objects.equals(sourceValue, targetValue)) {
                    this.validationResults.add(builder.ok(ValidationResult.ValidationType.BINARY_CHECKSUM, String.format("%s binary checksums match: %s", version, sourceValue)));
                } else {
                    this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_CHECKSUM, String.format("%s binary checksums do no match: sourceValue=%s, targetValue=%s", version, sourceValue, targetValue)));
                }
            }, () -> this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_CHECKSUM, String.format("%s binary checksum not found in Fedora 6 headers", version))));
        }
    }

    private void validateLastModified(DatastreamVersion dsVersion, ResourceHeaders headers, String version, ValidationResultBuilder builder) {
        Instant targetValue;
        String error = "%s binary last modified dates do no match: sourceValue=%s, targetValue=%s";
        String success = "%s binary last modified dates match: %s";
        Instant sourceValue = Instant.from(ISO_8601.parse(dsVersion.getCreated()));
        if (sourceValue.equals(targetValue = headers.getLastModifiedDate())) {
            this.validationResults.add(builder.ok(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary last modified dates match: %s", version, sourceValue)));
        } else {
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary last modified dates do no match: sourceValue=%s, targetValue=%s", version, sourceValue, targetValue)));
        }
    }

    private void validateCreatedDate(String sourceCreated, ResourceHeaders headers, String version, ValidationResultBuilder builder) {
        Instant targetCreated;
        String error = "%s binary creation dates do no match: sourceValue=%s, targetValue=%s";
        String success = "%s binary creation dates match: %s";
        Instant sourceInstant = Instant.from(ISO_8601.parse(sourceCreated));
        if (sourceInstant.equals(targetCreated = headers.getCreatedDate())) {
            this.validationResults.add(builder.ok(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary creation dates match: %s", version, sourceCreated)));
        } else {
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary creation dates do no match: sourceValue=%s, targetValue=%s", version, sourceCreated, targetCreated)));
        }
    }

    private void validateSize(DatastreamVersion dsVersion, ResourceHeaders headers, OcflObjectVersion ocflObjectVersion, String version, ValidationResultBuilder builder) {
        String error = "%s binary size does not match: sourceValue=%s, targetValue=%s";
        String success = "%s binary size matches: %s";
        String notFound = "%s %s file could not be found to check size!";
        DatastreamInfo dsInfo = dsVersion.getDatastreamInfo();
        F3ControlGroup controlGroup = F3ControlGroup.fromString(dsInfo.getControlGroup());
        if (controlGroup == F3ControlGroup.MANAGED) {
            long targetSize;
            long sourceSize = dsVersion.getSize();
            if (sourceSize == (targetSize = headers.getContentSize())) {
                this.validationResults.add(builder.ok(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary size matches: %s", version, sourceSize)));
            } else {
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary size does not match: sourceValue=%s, targetValue=%s", version, sourceSize, targetSize)));
            }
            Optional sourceFile = dsVersion.getFile();
            ValidationResult result = sourceFile.map(file -> {
                long targetBytes;
                String ocflRelativePath = ocflObjectVersion.getFile(headers.getContentPath()).getStorageRelativePath();
                Path targetPath = this.ocflRoot.resolve(ocflRelativePath);
                if (Files.notExists(targetPath, new LinkOption[0])) {
                    return builder.fail(ValidationResult.ValidationType.BINARY_SIZE, String.format("%s %s file could not be found to check size!", version, "target"));
                }
                long sourceBytes = file.length();
                if (sourceBytes == (targetBytes = targetPath.toFile().length())) {
                    return builder.ok(ValidationResult.ValidationType.BINARY_SIZE, String.format("%s binary size matches: %s", version, sourceBytes));
                }
                return builder.fail(ValidationResult.ValidationType.BINARY_SIZE, String.format("%s binary size does not match: sourceValue=%s, targetValue=%s", version, sourceBytes, targetBytes));
            }).orElse(builder.fail(ValidationResult.ValidationType.BINARY_SIZE, String.format("%s %s file could not be found to check size!", version, "source")));
            this.validationResults.add(result);
        }
    }

    private void completeObjectValidation() {
        String pid = this.objectInfo.getPid();
        String ocflId = this.ocflSession.ocflObjectId();
        String nonRdfSource = "http://www.w3.org/ns/ldp#NonRDFSource";
        long ocflResourceCount = this.ocflSession.streamResourceHeaders().filter(r -> !r.isDeleted() && r.getInteractionModel().equals("http://www.w3.org/ns/ldp#NonRDFSource")).count();
        ValidationResult.Status result = (long)this.headDatastreamIds.size() == ocflResourceCount ? ValidationResult.Status.OK : ValidationResult.Status.FAIL;
        String details = (long)this.headDatastreamIds.size() == ocflResourceCount ? "The number of binary objects in HEAD are identical." : String.format("The number of binary object in HEAD are not equal: f3-> %d vs f6-> %d", this.headDatastreamIds.size(), ocflResourceCount);
        this.validationResults.add(new ValidationResult(this.indexCounter++, result, ValidationResult.ValidationLevel.OBJECT, ValidationResult.ValidationType.BINARY_HEAD_COUNT, pid, ocflId, details));
    }

    private class ValidationResultBuilder {
        private final String sourceObjectId;
        private final String targetObjectId;
        private final String sourceResource;
        private final String targetResource;
        private final ValidationResult.ValidationLevel validationLevel;

        private ValidationResultBuilder(String sourceObjectId, String targetObjectId, String sourceResource, String targetResource, ValidationResult.ValidationLevel validationLevel) {
            this.sourceObjectId = sourceObjectId;
            this.targetObjectId = targetObjectId;
            this.sourceResource = sourceResource;
            this.targetResource = targetResource;
            this.validationLevel = validationLevel;
        }

        public ValidationResult ok(ValidationResult.ValidationType type, String details) {
            return new ValidationResult(ValidatingObjectHandler.this.indexCounter++, ValidationResult.Status.OK, this.validationLevel, type, this.sourceObjectId, this.targetObjectId, this.sourceResource, this.targetResource, details);
        }

        public ValidationResult fail(ValidationResult.ValidationType type, String details) {
            return new ValidationResult(ValidatingObjectHandler.this.indexCounter++, ValidationResult.Status.FAIL, this.validationLevel, type, this.sourceObjectId, this.targetObjectId, this.sourceResource, this.targetResource, details);
        }
    }

    private static interface DateTimeResolver
    extends PropertyResolver {
        @Override
        default public boolean equals(String source, String target) {
            Instant sourceDT = Instant.from(ISO_8601.parse(source));
            Instant targetDT = Instant.from(ISO_8601.parse(target));
            return sourceDT.equals(targetDT);
        }
    }

    private static interface PropertyResolver {
        public Optional<String> resolve(ResourceHeaders var1);

        default public boolean equals(String source, String target) {
            return source.equals(target);
        }

        default public Optional<String> fromModel(Model model, String ocflId, String property) {
            return Optional.ofNullable(model.getProperty(model.createResource(ocflId), model.createProperty(property))).map(Statement::getObject).map(RDFNode::toString);
        }
    }
}

