/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.api;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.fcrepo.migration.DatastreamInfo;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperty;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.impl.F3ControlGroup;
import org.fcrepo.migration.validator.impl.F6DigestAlgorithm;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ValidationHandler
extends FedoraObjectVersionHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(ValidationHandler.class);
    public static final DateTimeFormatter ISO_8601 = DateTimeFormatter.ISO_INSTANT;
    public static final String F3_LABEL = "info:fedora/fedora-system:def/model#label";
    public static final String F3_STATE = "info:fedora/fedora-system:def/model#state";
    public static final String F3_CREATED_DATE = "info:fedora/fedora-system:def/model#createdDate";
    public static final String F3_LAST_MODIFIED_DATE = "info:fedora/fedora-system:def/view#lastModifiedDate";
    public static final String F3_OWNER_ID = "info:fedora/fedora-system:def/model#ownerId";
    public static final String RELS_INT = "RELS-INT";
    public static final String DOWNLOAD_NAME_PROP = "info:fedora/fedora-system:def/model#downloadFilename";
    public static final String RELS_DELETED_ENTRY = "FCREPO_MIGRATION_VALIDATOR_DELETED_ENTRY";
    public static final Map<String, PropertyResolver> OCFL_PROPERTY_RESOLVERS = Map.of("info:fedora/fedora-system:def/model#label", headers -> Optional.empty(), "info:fedora/fedora-system:def/model#state", headers -> Optional.empty(), "info:fedora/fedora-system:def/model#ownerId", headers -> Optional.empty(), "info:fedora/fedora-system:def/model#createdDate", headers -> Optional.of(headers.getCreatedDate().toString()), "info:fedora/fedora-system:def/view#lastModifiedDate", headers -> Optional.of(headers.getLastModifiedDate().toString()));

    default public Model parseRdf(DatastreamVersion dv) {
        Model model;
        block8: {
            Model model2 = ModelFactory.createDefaultModel();
            InputStream is = dv.getContent();
            try {
                RDFDataMgr.read((Model)model2, (InputStream)is, (Lang)Lang.RDFXML);
                model = model2;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse RDF XML", e);
                }
            }
            is.close();
        }
        return model;
    }

    default public Map<String, Model> splitRelsInt(Model relsIntModel) {
        String infoFedora = "info:fedora/";
        HashMap<String, Model> splitModels = new HashMap<String, Model>();
        StmtIterator it = relsIntModel.listStatements();
        while (it.hasNext()) {
            Statement statement = (Statement)it.next();
            String uri = statement.getSubject().getURI();
            String id = uri.startsWith("info:fedora/") ? uri.substring("info:fedora/".length()) : uri;
            Model model = splitModels.computeIfAbsent(id, k -> ModelFactory.createDefaultModel());
            model.add(statement);
        }
        return splitModels;
    }

    default public Optional<ValidationResult> validateObjectProperty(String ocflId, ObjectInfo objectInfo, ObjectProperty op, ResourceHeaders headers, Model model, ValidationResultBuilder builder) {
        Optional<ValidationResult> result = Optional.empty();
        String pid = objectInfo.getPid();
        String property = op.getName();
        String sourceValue = op.getValue();
        LOGGER.debug("PID = {}, object property: name = {}, value = {}", new Object[]{pid, property, sourceValue});
        PropertyResolver resolver = OCFL_PROPERTY_RESOLVERS.get(property);
        if (resolver != null) {
            String success = "pid: %s -> properties match: f3 prop name=%s, source=%s, target=%s";
            String error = "pid: %s -> properties do not match: f3 prop name=%s, source=%s, target=%s";
            String notFound = "pid: %s -> property not found in OCFL: f3 prop name=%s, source=%s";
            result = resolver.resolve(headers).or(() -> resolver.fromModel(model, ocflId, property)).map(targetVal -> resolver.equals(sourceValue, (String)targetVal) ? builder.ok(ValidationResult.ValidationType.METADATA, String.format("pid: %s -> properties match: f3 prop name=%s, source=%s, target=%s", pid, property, sourceValue, targetVal)) : builder.fail(ValidationResult.ValidationType.METADATA, String.format("pid: %s -> properties do not match: f3 prop name=%s, source=%s, target=%s", pid, property, sourceValue, targetVal))).or(() -> Optional.of(builder.fail(ValidationResult.ValidationType.METADATA, String.format("pid: %s -> property not found in OCFL: f3 prop name=%s, source=%s", pid, property, sourceValue))));
        }
        return result;
    }

    default public Optional<ValidationResult> validateSizeMeta(DatastreamVersion dsVersion, ResourceHeaders headers, String version, ValidationResultBuilder builder) {
        Optional<ValidationResult> result = Optional.empty();
        String error = "%s binary size does not match: sourceValue=%s, targetValue=%s";
        String success = "%s binary size matches: %s";
        DatastreamInfo dsInfo = dsVersion.getDatastreamInfo();
        F3ControlGroup controlGroup = F3ControlGroup.fromString(dsInfo.getControlGroup());
        if (controlGroup == F3ControlGroup.MANAGED) {
            long targetSize;
            long sourceSize = dsVersion.getSize();
            result = sourceSize == (targetSize = headers.getContentSize()) ? Optional.of(builder.ok(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary size matches: %s", version, sourceSize))) : Optional.of(builder.fail(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary size does not match: sourceValue=%s, targetValue=%s", version, sourceSize, targetSize)));
        }
        return result;
    }

    default public Optional<ValidationResult> validateSizeOnDisk(DatastreamVersion dsVersion, Path ocflRoot, ResourceHeaders headers, OcflObjectVersion ocflObjectVersion, String version, ValidationResultBuilder builder) {
        String error = "%s binary size does not match: sourceValue=%s, targetValue=%s";
        String success = "%s binary size matches: %s";
        String notFound = "%s %s file could not be found to check size!";
        DatastreamInfo dsInfo = dsVersion.getDatastreamInfo();
        F3ControlGroup controlGroup = F3ControlGroup.fromString(dsInfo.getControlGroup());
        if (controlGroup == F3ControlGroup.MANAGED) {
            Optional sourceFile = dsVersion.getFile();
            return sourceFile.map(file -> {
                long targetBytes;
                String ocflRelativePath = ocflObjectVersion.getFile(headers.getContentPath()).getStorageRelativePath();
                Path targetPath = ocflRoot.resolve(ocflRelativePath);
                if (Files.notExists(targetPath, new LinkOption[0])) {
                    return builder.fail(ValidationResult.ValidationType.BINARY_SIZE, String.format("%s %s file could not be found to check size!", version, "target"));
                }
                long sourceBytes = file.length();
                if (sourceBytes == (targetBytes = targetPath.toFile().length())) {
                    return builder.ok(ValidationResult.ValidationType.BINARY_SIZE, String.format("%s binary size matches: %s", version, sourceBytes));
                }
                return builder.fail(ValidationResult.ValidationType.BINARY_SIZE, String.format("%s binary size does not match: sourceValue=%s, targetValue=%s", version, sourceBytes, targetBytes));
            }).or(() -> Optional.of(builder.fail(ValidationResult.ValidationType.BINARY_SIZE, String.format("%s %s file could not be found to check size!", version, "source"))));
        }
        return Optional.empty();
    }

    default public Optional<ValidationResult> validateCreatedDate(String sourceCreated, ResourceHeaders headers, String version, ValidationResultBuilder builder) {
        Instant targetCreated;
        String error = "%s binary creation dates do no match: sourceValue=%s, targetValue=%s";
        String success = "%s binary creation dates match: %s";
        Instant sourceInstant = Instant.from(ISO_8601.parse(sourceCreated));
        Optional<ValidationResult> result = sourceInstant.equals(targetCreated = headers.getCreatedDate()) ? Optional.of(builder.ok(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary creation dates match: %s", version, sourceCreated))) : Optional.of(builder.fail(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary creation dates do no match: sourceValue=%s, targetValue=%s", version, sourceCreated, targetCreated)));
        return result;
    }

    default public Optional<ValidationResult> validateLastModified(DatastreamVersion dsVersion, ResourceHeaders headers, String version, ValidationResultBuilder builder) {
        Instant targetValue;
        String error = "%s binary last modified dates do no match: sourceValue=%s, targetValue=%s";
        String success = "%s binary last modified dates match: %s";
        Instant sourceValue = Instant.from(ISO_8601.parse(dsVersion.getCreated()));
        Optional<ValidationResult> result = sourceValue.equals(targetValue = headers.getLastModifiedDate()) ? Optional.of(builder.ok(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary last modified dates match: %s", version, sourceValue))) : Optional.of(builder.fail(ValidationResult.ValidationType.BINARY_METADATA, String.format("%s binary last modified dates do no match: sourceValue=%s, targetValue=%s", version, sourceValue, targetValue)));
        return result;
    }

    default public Optional<ValidationResult> validateChecksum(DatastreamVersion dsVersion, ResourceHeaders headers, F6DigestAlgorithm digestAlgorithm, String version, ValidationResultBuilder builder) {
        Optional<ValidationResult> result = Optional.empty();
        String success = "%s binary checksums match: %s";
        String error = "%s binary checksums do no match: sourceValue=%s, targetValue=%s";
        String notFound = "%s binary checksum not found in Fedora 6 headers";
        String exception = "%s binary checksum was unable to be calculated: exception=%s";
        F3ControlGroup controlGroup = F3ControlGroup.fromString(dsVersion.getDatastreamInfo().getControlGroup());
        if (controlGroup == F3ControlGroup.MANAGED) {
            HashCode sourceHash;
            try {
                Hasher hasher = digestAlgorithm.hasher();
                ByteStreams.copy((InputStream)dsVersion.getContent(), (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
                sourceHash = hasher.hash();
            }
            catch (IOException e) {
                return Optional.of(builder.fail(ValidationResult.ValidationType.BINARY_CHECKSUM, String.format("%s binary checksum was unable to be calculated: exception=%s", version, e)));
            }
            Optional<String> ocflDigest = headers.getDigests().stream().map(URI::toString).filter(uri -> uri.startsWith(digestAlgorithm.getOcflUrn())).map(uri -> uri.substring(uri.lastIndexOf(":") + 1)).findFirst();
            String sourceValue = sourceHash.toString();
            result = ocflDigest.map(targetValue -> {
                if (Objects.equals(sourceValue, targetValue)) {
                    return builder.ok(ValidationResult.ValidationType.BINARY_CHECKSUM, String.format("%s binary checksums match: %s", version, sourceValue));
                }
                return builder.fail(ValidationResult.ValidationType.BINARY_CHECKSUM, String.format("%s binary checksums do no match: sourceValue=%s, targetValue=%s", version, sourceValue, targetValue));
            }).or(() -> Optional.of(builder.fail(ValidationResult.ValidationType.BINARY_CHECKSUM, String.format("%s binary checksum not found in Fedora 6 headers", version))));
        }
        return result;
    }

    public List<ValidationResult> getValidationResults();

    public static class ValidationResultBuilder {
        private final String sourceObjectId;
        private final String targetObjectId;
        private final String sourceResource;
        private final String targetResource;
        private final ValidationResult.ValidationLevel validationLevel;
        private final AtomicInteger index;

        public ValidationResultBuilder(String sourceObjectId, String targetObjectId, String sourceResource, String targetResource, ValidationResult.ValidationLevel validationLevel, AtomicInteger index) {
            this.sourceObjectId = sourceObjectId;
            this.targetObjectId = targetObjectId;
            this.sourceResource = sourceResource;
            this.targetResource = targetResource;
            this.validationLevel = validationLevel;
            this.index = index;
        }

        public ValidationResult ok(ValidationResult.ValidationType type, String details) {
            return new ValidationResult(this.index.getAndIncrement(), ValidationResult.Status.OK, this.validationLevel, type, this.sourceObjectId, this.targetObjectId, this.sourceResource, this.targetResource, details);
        }

        public ValidationResult fail(ValidationResult.ValidationType type, String details) {
            LOGGER.info("[{}] {} validation failed: {}", new Object[]{this.sourceObjectId, type, details});
            return new ValidationResult(this.index.getAndIncrement(), ValidationResult.Status.FAIL, this.validationLevel, type, this.sourceObjectId, this.targetObjectId, this.sourceResource, this.targetResource, details);
        }
    }

    public static interface DateTimeResolver
    extends PropertyResolver {
        @Override
        default public boolean equals(String source, String target) {
            Instant sourceDT = Instant.from(ISO_8601.parse(source));
            Instant targetDT = Instant.from(ISO_8601.parse(target));
            return sourceDT.equals(targetDT);
        }
    }

    public static interface PropertyResolver {
        public Optional<String> resolve(ResourceHeaders var1);

        default public boolean equals(String source, String target) {
            return source.equals(target);
        }

        default public Optional<String> fromModel(Model model, String ocflId, String property) {
            return Optional.ofNullable(model.getProperty(model.createResource(ocflId), model.createProperty(property))).map(Statement::getObject).filter(RDFNode::isLiteral).map(node -> node.asLiteral().getLexicalForm());
        }
    }
}

