/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import java.util.List;
import java.util.Optional;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.validator.api.ObjectValidationConfig;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.ValidationResultWriter;
import org.fcrepo.migration.validator.api.ValidationTask;
import org.fcrepo.migration.validator.impl.Fedora3ObjectValidator;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class F3ObjectValidationTask
extends ValidationTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(F3ObjectValidationTask.class);
    private final FedoraObjectProcessor processor;
    private final OcflObjectSessionFactory ocflObjectSessionFactory;
    private final ValidationResultWriter writer;
    private final ObjectValidationConfig objectValidationConfig;

    public F3ObjectValidationTask(FedoraObjectProcessor processor, OcflObjectSessionFactory ocflObjectSessionFactory, ValidationResultWriter writer, ObjectValidationConfig objectValidationConfig) {
        this.processor = processor;
        this.ocflObjectSessionFactory = ocflObjectSessionFactory;
        this.writer = writer;
        this.objectValidationConfig = objectValidationConfig;
    }

    @Override
    public ValidationTask get() {
        LOGGER.info("Processing {} ", (Object)this.processor.getObjectInfo().getPid());
        Fedora3ObjectValidator validator = new Fedora3ObjectValidator(this.ocflObjectSessionFactory, this.objectValidationConfig);
        List<ValidationResult> results = validator.validate(this.processor);
        this.writer.write(results);
        return this;
    }

    @Override
    public Optional<String> getPid() {
        return Optional.of(this.processor.getObjectInfo().getPid());
    }
}

