/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import java.util.ArrayList;
import java.util.List;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.StreamingFedoraObjectHandler;
import org.fcrepo.migration.handlers.ObjectAbstractionStreamingFedoraObjectHandler;
import org.fcrepo.migration.validator.api.ObjectValidationConfig;
import org.fcrepo.migration.validator.api.ValidationHandler;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.Validator;
import org.fcrepo.migration.validator.impl.HeadOnlyValidationHandler;
import org.fcrepo.migration.validator.impl.ValidatingObjectHandler;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fedora3ObjectValidator
implements Validator<FedoraObjectProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fedora3ObjectValidator.class);
    private final OcflObjectSessionFactory factory;
    private final ObjectValidationConfig objectValidationConfig;

    public Fedora3ObjectValidator(OcflObjectSessionFactory factory, ObjectValidationConfig objectValidationConfig) {
        this.factory = factory;
        this.objectValidationConfig = objectValidationConfig;
    }

    @Override
    public List<ValidationResult> validate(FedoraObjectProcessor object) {
        List<ValidationResult> list;
        block9: {
            ObjectInfo objectInfo = object.getObjectInfo();
            Object fedoraId = objectInfo.getFedoraURI();
            if (fedoraId == null) {
                fedoraId = "info:fedora/" + objectInfo.getPid();
            }
            OcflObjectSession ocflSession = this.factory.newSession((String)fedoraId);
            ValidationHandler handler = this.objectValidationConfig.isValidateHeadOnly() ? new HeadOnlyValidationHandler(ocflSession, this.objectValidationConfig) : new ValidatingObjectHandler(ocflSession, this.objectValidationConfig);
            FedoraObjectProcessor fedoraObjectProcessor = object;
            try {
                object.processObject((StreamingFedoraObjectHandler)new ObjectAbstractionStreamingFedoraObjectHandler((FedoraObjectVersionHandler)handler));
                list = handler.getValidationResults();
                if (fedoraObjectProcessor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fedoraObjectProcessor != null) {
                        try {
                            fedoraObjectProcessor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOGGER.error("Source object {} could not be read due to: {}", new Object[]{objectInfo.getPid(), ex.getMessage(), ex});
                    List<ValidationResult> results = handler.getValidationResults();
                    ArrayList<ValidationResult> list2 = new ArrayList<ValidationResult>(results);
                    list2.add(new ValidationResult(results.size(), ValidationResult.Status.FAIL, ValidationResult.ValidationLevel.OBJECT, ValidationResult.ValidationType.OBJECT_READABLE, (String)fedoraId, ocflSession.ocflObjectId(), "Source object could not be read: " + ex.getMessage()));
                    return list2;
                }
            }
            fedoraObjectProcessor.close();
        }
        return list;
    }
}

