/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.ObjectSource;
import org.fcrepo.migration.validator.api.ObjectValidationConfig;
import org.fcrepo.migration.validator.api.ResumeManager;
import org.fcrepo.migration.validator.api.ValidationExecutionManager;
import org.fcrepo.migration.validator.api.ValidationResultWriter;
import org.fcrepo.migration.validator.api.ValidationTask;
import org.fcrepo.migration.validator.impl.ApplicationConfigurationHelper;
import org.fcrepo.migration.validator.impl.F3ObjectValidationTask;
import org.fcrepo.migration.validator.impl.F3ObjectValidationTaskBuilder;
import org.fcrepo.migration.validator.impl.F3RepositoryValidationTask;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fedora3ValidationExecutionManager
implements ValidationExecutionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fedora3ValidationExecutionManager.class);
    private long numProcessed;
    private final int limit;
    private final AtomicBoolean abort;
    private final Semaphore semaphore;
    private final ResumeManager resumeManager;
    private final ExecutorService executorService;
    private final OcflObjectSessionFactory ocflObjectSessionFactory;
    private final ValidationResultWriter writer;
    private final ObjectSource source;
    private final Set<String> objectsToValidate;
    private final ObjectValidationConfig objectValidationConfig;
    private final ApplicationConfigurationHelper config;

    public Fedora3ValidationExecutionManager(ApplicationConfigurationHelper config) {
        this.config = config;
        this.limit = config.getLimit();
        this.source = config.objectSource();
        this.writer = config.validationResultWriter();
        this.objectsToValidate = config.readObjectsToValidate();
        this.ocflObjectSessionFactory = config.ocflObjectSessionFactory();
        this.executorService = Executors.newFixedThreadPool(config.getThreadCount());
        this.semaphore = new Semaphore(config.getThreadCount());
        this.objectValidationConfig = config.getObjectValidationConfig();
        this.abort = new AtomicBoolean();
        this.resumeManager = config.resumeManager();
        this.numProcessed = 0L;
    }

    @Override
    public boolean doValidation() {
        try {
            boolean halted = false;
            for (FedoraObjectProcessor objectProcessor : this.source) {
                if (!this.resumeManager.accept(objectProcessor.getObjectInfo().getPid())) continue;
                if (this.abort.get() || halted) break;
                ++this.numProcessed;
                String sourceObjectId = objectProcessor.getObjectInfo().getPid();
                try {
                    if (this.objectsToValidate.isEmpty() || this.objectsToValidate.contains(sourceObjectId)) {
                        F3ObjectValidationTask task = (F3ObjectValidationTask)new F3ObjectValidationTaskBuilder().processor(objectProcessor).withValidationConfig(this.objectValidationConfig).writer(this.writer).objectSessionFactory(this.ocflObjectSessionFactory).build();
                        this.submit(task);
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.error("Error submitting task", (Throwable)ex);
                    this.abort.set(true);
                }
                halted = this.limit != 0 && (long)this.limit <= this.numProcessed;
            }
            if (!halted) {
                F3RepositoryValidationTask repositoryTask = new F3RepositoryValidationTask(this.config, this.writer);
                this.submit(repositoryTask);
            }
            this.awaitCompletion();
            this.resumeManager.updateResumeFile();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.shutdown();
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.abort.get();
    }

    private void submit(ValidationTask task) throws InterruptedException {
        this.semaphore.acquire();
        CompletableFuture.supplyAsync(task, this.executorService).whenComplete(this::finishTask);
    }

    private void finishTask(ValidationTask task, Throwable throwable) {
        if (throwable != null) {
            LOGGER.error("Validation task failed", throwable);
            this.abort.set(true);
        } else {
            task.getPid().ifPresent(this.resumeManager::completed);
        }
        this.semaphore.release();
    }

    private void awaitCompletion() throws InterruptedException {
        this.semaphore.acquire(this.config.getThreadCount());
    }

    private void shutdown() throws InterruptedException {
        this.executorService.shutdown();
        if (!this.executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
            LOGGER.error("Failed to shutdown executor service cleanly after 1 minute of waiting");
            this.executorService.shutdownNow();
        }
    }

    public long getNumProcessed() {
        return this.numProcessed;
    }
}

