/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import edu.wisc.library.ocfl.api.OcflRepository;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.fcrepo.migration.DatastreamInfo;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectProperty;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.ObjectVersionReference;
import org.fcrepo.migration.validator.api.ObjectValidationConfig;
import org.fcrepo.migration.validator.api.ValidationHandler;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.impl.F3State;
import org.fcrepo.migration.validator.impl.F6DigestAlgorithm;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadOnlyValidationHandler
implements ValidationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadOnlyValidationHandler.class);
    private ObjectInfo objectInfo;
    private final AtomicInteger index = new AtomicInteger();
    private final Path ocflRoot;
    private final boolean checksum;
    private final boolean deleteInactive;
    private final OcflRepository repository;
    private final OcflObjectSession ocflSession;
    private final F6DigestAlgorithm digestAlgorithm;
    private final List<ValidationResult> validationResults;

    public HeadOnlyValidationHandler(OcflObjectSession session, ObjectValidationConfig config) {
        this.ocflSession = session;
        this.checksum = config.isChecksum();
        this.ocflRoot = config.getOcflRoot();
        this.deleteInactive = config.deleteInactive();
        this.digestAlgorithm = config.getDigestAlgorithm();
        this.repository = config.getOcflRepository();
        this.validationResults = new ArrayList<ValidationResult>();
    }

    public void processObjectVersions(Iterable<ObjectVersionReference> iterable, ObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
        Iterator<ObjectVersionReference> referenceIterator = iterable.iterator();
        if (referenceIterator.hasNext()) {
            ObjectReference objectReference = referenceIterator.next().getObject();
            LOGGER.debug("beginning processing on object: pid={}", (Object)objectInfo);
            if (this.initialObjectValidation(objectReference.getObjectProperties())) {
                objectReference.listDatastreamIds().forEach(dsId -> this.validateDatastream((String)dsId, objectReference));
            }
        }
    }

    private boolean initialObjectValidation(ObjectProperties objectProperties) {
        String errorActive = "Source object not found in target repository";
        String errorDeleted = "Source object should be deleted in target repository";
        String successDeleted = "Source object deleted in target repository";
        String pid = this.objectInfo.getPid();
        String ocflId = this.ocflSession.ocflObjectId();
        Model model = ModelFactory.createDefaultModel();
        ValidationHandler.ValidationResultBuilder builder = new ValidationHandler.ValidationResultBuilder(pid, ocflId, null, null, ValidationResult.ValidationLevel.OBJECT, this.index);
        List properties = objectProperties.listProperties();
        ObjectProperty stateProperty = properties.stream().filter(p -> p.getName().equals("info:fedora/fedora-system:def/model#state")).findFirst().orElseThrow(() -> new IllegalStateException("Could not find info:fedora/fedora-system:def/model#stateon object" + ocflId));
        boolean continueValidations = false;
        F3State objectState = F3State.fromProperty(stateProperty);
        boolean isDeleted = objectState.isDeleted(this.deleteInactive);
        try {
            ResourceHeaders headers = this.ocflSession.readHeaders(ocflId);
            if (!isDeleted) {
                this.ocflSession.readContent(ocflId).getContentStream().ifPresent(is -> RDFDataMgr.read((Model)model, (InputStream)is, (Lang)RDFFormat.NTRIPLES.getLang()));
                properties.forEach(op -> this.validateObjectProperty(ocflId, this.objectInfo, (ObjectProperty)op, headers, model, builder).ifPresent(this.validationResults::add));
                continueValidations = true;
            } else {
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_EXISTS_IN_TARGET, "Source object should be deleted in target repository"));
            }
        }
        catch (NotFoundException ignored) {
            if (isDeleted) {
                this.validationResults.add(builder.ok(ValidationResult.ValidationType.SOURCE_OBJECT_EXISTS_IN_TARGET, "Source object deleted in target repository"));
            }
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_EXISTS_IN_TARGET, "Source object not found in target repository"));
        }
        return continueValidations;
    }

    private void validateDatastream(String dsId, ObjectReference objectReference) {
        List dsVersions = objectReference.getDatastreamVersions(dsId);
        String sourceObjectId = this.objectInfo.getPid();
        String targetObjectId = this.ocflSession.ocflObjectId();
        String sourceResource = sourceObjectId + "/" + dsId;
        String targetResource = targetObjectId + "/" + dsId;
        ValidationHandler.ValidationResultBuilder builder = new ValidationHandler.ValidationResultBuilder(sourceObjectId, targetObjectId, sourceResource, targetResource, ValidationResult.ValidationLevel.OBJECT_RESOURCE, this.index);
        DatastreamVersion head = (DatastreamVersion)dsVersions.get(dsVersions.size() - 1);
        DatastreamInfo dsInfo = head.getDatastreamInfo();
        F3State state = F3State.fromString(dsInfo.getState());
        if (state.isDeleted(this.deleteInactive)) {
            String success = "Source object resource deleted from ocfl object";
            String error = "Source object resource does not exist in target for source version";
            try {
                this.ocflSession.readHeaders(targetResource);
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_EXISTS_IN_TARGET, "Source object resource does not exist in target for source version"));
            }
            catch (NotFoundException ex) {
                this.validationResults.add(builder.ok(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_EXISTS_IN_TARGET, "Source object resource deleted from ocfl object"));
            }
            return;
        }
        String created = ((DatastreamVersion)dsVersions.get(0)).getCreated();
        try {
            ResourceHeaders headers = this.ocflSession.readHeaders(targetResource);
            List versions = this.ocflSession.listVersions(targetResource);
            OcflVersionInfo ocflVersionInfo = (OcflVersionInfo)versions.get(0);
            ObjectVersionId objectVersionId = ObjectVersionId.version((String)ocflVersionInfo.getOcflObjectId(), (String)ocflVersionInfo.getVersionNumber());
            OcflObjectVersion ocflObject = this.repository.getObject(objectVersionId);
            this.validateSizeMeta(head, headers, "HEAD", builder).ifPresent(this.validationResults::add);
            this.validateSizeOnDisk(head, this.ocflRoot, headers, ocflObject, "HEAD", builder).ifPresent(this.validationResults::add);
            this.validateCreatedDate(created, headers, "HEAD", builder).ifPresent(this.validationResults::add);
            this.validateLastModified(head, headers, "HEAD", builder).ifPresent(this.validationResults::add);
            if (this.checksum) {
                this.validateChecksum(head, headers, this.digestAlgorithm, "HEAD", builder).ifPresent(this.validationResults::add);
            }
            if (versions.size() == 1) {
                String versionSuccess = "Resource has single binary version";
                this.validationResults.add(builder.ok(ValidationResult.ValidationType.BINARY_VERSION_COUNT, "Resource has single binary version"));
            } else {
                String versionFailure = "Resource has more than just a HEAD version: count=%s";
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_VERSION_COUNT, String.format("Resource has more than just a HEAD version: count=%s", versions.size())));
            }
        }
        catch (NotFoundException ignored) {
            String readError = "Source object resource does not exist in target";
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_EXISTS_IN_TARGET, "Source object resource does not exist in target"));
        }
    }

    @Override
    public List<ValidationResult> getValidationResults() {
        return this.validationResults;
    }
}

