/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import com.google.common.collect.Sets;
import edu.wisc.library.ocfl.api.OcflRepository;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.fcrepo.migration.DatastreamInfo;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectProperty;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.ObjectVersionReference;
import org.fcrepo.migration.validator.api.ObjectValidationConfig;
import org.fcrepo.migration.validator.api.ValidationHandler;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.impl.F3State;
import org.fcrepo.migration.validator.impl.F6DigestAlgorithm;
import org.fcrepo.migration.validator.impl.Fedora3ObjectValidator;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatingObjectHandler
implements ValidationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fedora3ObjectValidator.class);
    private F3State objectState;
    private ObjectInfo objectInfo;
    private final boolean checksum;
    private final boolean deleteInactive;
    private final Path ocflRoot;
    private final OcflRepository repository;
    private final OcflObjectSession ocflSession;
    private final List<ValidationResult> validationResults = new ArrayList<ValidationResult>();
    private final AtomicInteger index;
    private final Set<String> headDatastreamIds = new HashSet<String>();
    private final F6DigestAlgorithm digestAlgorithm;
    private final Map<String, List<String>> relsFilenames = new HashMap<String, List<String>>();

    public void processObjectVersions(Iterable<ObjectVersionReference> iterable, ObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
        Iterator<ObjectVersionReference> referenceIterator = iterable.iterator();
        if (referenceIterator.hasNext()) {
            ObjectReference objectReference = referenceIterator.next().getObject();
            LOGGER.debug("beginning processing on object: pid={}", (Object)objectInfo);
            if (this.initialObjectValidation(objectReference.getObjectProperties())) {
                this.preprocessRelsInt(objectReference);
                objectReference.listDatastreamIds().forEach(dsId -> this.validateDatastream((String)dsId, objectReference));
                this.completeObjectValidation();
            }
        }
    }

    private void preprocessRelsInt(ObjectReference objectReference) {
        String pid = this.objectInfo.getPid();
        HashMap filenameMap = new HashMap();
        List dsVersions = Optional.ofNullable(objectReference.getDatastreamVersions("RELS-INT")).orElse(List.of());
        for (DatastreamVersion dsVersion : dsVersions) {
            Model rdf = this.parseRdf(dsVersion);
            Map<String, Model> models = this.splitRelsInt(rdf);
            HashSet oldIds = new HashSet(filenameMap.keySet());
            filenameMap.clear();
            models.forEach((id, model) -> model.listStatements().forEach(statement -> {
                if ("info:fedora/fedora-system:def/model#downloadFilename".equals(statement.getPredicate().getURI())) {
                    LOGGER.trace("{} has download prop for {}", (Object)pid, id);
                    String filename = statement.getObject().toString();
                    List prevFilenames = this.relsFilenames.computeIfAbsent((String)id, ignored -> new ArrayList<String>(List.of(filename)));
                    if (!((String)prevFilenames.get(prevFilenames.size() - 1)).equals(filename)) {
                        prevFilenames.add(filename);
                    }
                    filenameMap.put(id, statement.getObject().toString());
                }
            }));
            Sets.SetView deleted = Sets.difference(oldIds, filenameMap.keySet());
            deleted.forEach(id -> {
                LOGGER.trace("{} has a deleted download prop for {}", (Object)pid, id);
                this.relsFilenames.get(id).add("FCREPO_MIGRATION_VALIDATOR_DELETED_ENTRY");
            });
        }
    }

    public ValidatingObjectHandler(OcflObjectSession session, ObjectValidationConfig config) {
        this.ocflSession = session;
        this.index = new AtomicInteger();
        this.checksum = config.isChecksum();
        this.ocflRoot = config.getOcflRoot();
        this.repository = config.getOcflRepository();
        this.deleteInactive = config.deleteInactive();
        this.digestAlgorithm = config.getDigestAlgorithm();
    }

    @Override
    public List<ValidationResult> getValidationResults() {
        return this.validationResults;
    }

    private boolean initialObjectValidation(ObjectProperties objectProperties) {
        ResourceHeaders headers;
        String pid = this.objectInfo.getPid();
        String ocflId = this.ocflSession.ocflObjectId();
        Model model = ModelFactory.createDefaultModel();
        ValidationHandler.ValidationResultBuilder builder = new ValidationHandler.ValidationResultBuilder(pid, ocflId, null, null, ValidationResult.ValidationLevel.OBJECT, this.index);
        try {
            headers = this.ocflSession.readHeaders(ocflId);
            this.ocflSession.readContent(ocflId).getContentStream().ifPresent(is -> RDFDataMgr.read((Model)model, (InputStream)is, (Lang)RDFFormat.NTRIPLES.getLang()));
            this.validationResults.add(builder.ok(ValidationResult.ValidationType.SOURCE_OBJECT_EXISTS_IN_TARGET, "Source object is present in target repository."));
        }
        catch (NotFoundException ex) {
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_EXISTS_IN_TARGET, "Source object is not present in target repository."));
            return false;
        }
        List properties = objectProperties.listProperties();
        ObjectProperty stateProperty = properties.stream().filter(p -> p.getName().equals("info:fedora/fedora-system:def/model#state")).findFirst().orElseThrow(() -> new IllegalStateException("Could not find info:fedora/fedora-system:def/model#stateon object" + ocflId));
        this.objectState = F3State.fromProperty(stateProperty);
        if (this.objectState.isDeleted(this.deleteInactive)) {
            String success = "pid: %s -> object deleted states match: source=%s, target=%s";
            String error = "pid: %s -> object deleted states do not match: source=%s, target=%s";
            ValidationResult deletedResult = headers.isDeleted() ? builder.ok(ValidationResult.ValidationType.SOURCE_OBJECT_DELETED, String.format("pid: %s -> object deleted states match: source=%s, target=%s", new Object[]{pid, this.objectState, true})) : builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_DELETED, String.format("pid: %s -> object deleted states do not match: source=%s, target=%s", new Object[]{pid, this.objectState, false}));
            this.validationResults.add(deletedResult);
        } else {
            properties.forEach(op -> this.validateObjectProperty(ocflId, this.objectInfo, (ObjectProperty)op, headers, model, builder).ifPresent(this.validationResults::add));
        }
        return true;
    }

    public void validateDatastream(String dsId, ObjectReference objectReference) {
        List dsVersions = objectReference.getDatastreamVersions(dsId);
        String sourceObjectId = this.objectInfo.getPid();
        String targetObjectId = this.ocflSession.ocflObjectId();
        String sourceResource = sourceObjectId + "/" + dsId;
        String targetResource = targetObjectId + "/" + dsId;
        List targetVersions = this.ocflSession.listVersions(targetResource);
        ValidationHandler.ValidationResultBuilder builder = new ValidationHandler.ValidationResultBuilder(sourceObjectId, targetObjectId, sourceResource, targetResource, ValidationResult.ValidationLevel.OBJECT_RESOURCE, this.index);
        int sourceVersionCount = 0;
        int sourceDeletedCount = 0;
        String sourceCreated = null;
        Optional<List<String>> downloadFilenames = Optional.ofNullable(this.relsFilenames.get(sourceResource));
        int softVersionCount = downloadFilenames.map(filenames -> this.searchSoftVersions(sourceResource, targetVersions, (List<String>)filenames)).orElse(0);
        for (DatastreamVersion dsVersion : dsVersions) {
            int currentVersion;
            Object version;
            boolean isHead;
            DatastreamInfo dsInfo = dsVersion.getDatastreamInfo();
            if (sourceCreated == null) {
                sourceCreated = dsVersion.getCreated();
            }
            if (isHead = dsVersion.isLastVersionIn(objectReference)) {
                version = "HEAD";
                this.headDatastreamIds.add(dsId);
                currentVersion = sourceVersionCount + softVersionCount;
            } else {
                version = "version " + sourceVersionCount;
                currentVersion = sourceVersionCount;
            }
            try {
                OcflVersionInfo ocflVersionInfo = (OcflVersionInfo)targetVersions.get(currentVersion + sourceDeletedCount);
                ObjectVersionId objectVersionId = ObjectVersionId.version((String)ocflVersionInfo.getOcflObjectId(), (String)ocflVersionInfo.getVersionNumber());
                ResourceHeaders headers = this.ocflSession.readHeaders(targetResource, ocflVersionInfo.getVersionNumber());
                OcflObjectVersion ocflObject = this.repository.getObject(objectVersionId);
                this.validateSizeMeta(dsVersion, headers, (String)version, builder).ifPresent(this.validationResults::add);
                this.validateSizeOnDisk(dsVersion, this.ocflRoot, headers, ocflObject, (String)version, builder).ifPresent(this.validationResults::add);
                this.validateCreatedDate(sourceCreated, headers, (String)version, builder).ifPresent(this.validationResults::add);
                this.validateLastModified(dsVersion, headers, (String)version, builder).ifPresent(this.validationResults::add);
                if (this.checksum) {
                    this.validateChecksum(dsVersion, headers, this.digestAlgorithm, (String)version, builder).ifPresent(this.validationResults::add);
                }
            }
            catch (IndexOutOfBoundsException | NotFoundException ex) {
                String error = "Source object resource does not exist in target for source version=%d";
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_EXISTS_IN_TARGET, String.format("Source object resource does not exist in target for source version=%d", currentVersion)));
            }
            F3State state = F3State.fromString(dsInfo.getState());
            if (state.isDeleted(this.deleteInactive) || isHead && this.objectState.isDeleted(this.deleteInactive)) {
                ++sourceDeletedCount;
                this.headDatastreamIds.remove(dsId);
                this.validateDeleted(targetResource, currentVersion, targetVersions, builder);
            }
            ++sourceVersionCount;
        }
        String versionSuccess = "binary version counts match for resource: source=%d, RELS-INT=%d, target=%d";
        String versionFailure = "binary version counts do not match for resource: source=%d, RELS-INT=%d, target=%d";
        int f3VersionCount = sourceVersionCount + softVersionCount;
        int targetVersionCount = targetVersions.size() - sourceDeletedCount;
        if (f3VersionCount == targetVersionCount) {
            String details = String.format("binary version counts match for resource: source=%d, RELS-INT=%d, target=%d", sourceVersionCount, softVersionCount, targetVersionCount);
            this.validationResults.add(builder.ok(ValidationResult.ValidationType.BINARY_VERSION_COUNT, details));
        } else {
            String details = String.format("binary version counts do not match for resource: source=%d, RELS-INT=%d, target=%d", sourceVersionCount, softVersionCount, targetVersionCount);
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.BINARY_VERSION_COUNT, details));
        }
    }

    private int searchSoftVersions(String sourceResource, List<OcflVersionInfo> targetVersions, List<String> filenames) {
        int transitions = 0;
        for (OcflVersionInfo targetVersion : targetVersions) {
            ResourceHeaders headers;
            if (filenames.isEmpty()) break;
            String f3Filename = filenames.remove(0);
            if (f3Filename.equals((headers = this.ocflSession.readHeaders(targetVersion.getResourceId(), targetVersion.getVersionNumber())).getFilename())) continue;
            LOGGER.debug("{} has filename update {} -> {}", new Object[]{sourceResource, headers.getFilename(), f3Filename});
            ++transitions;
        }
        return transitions;
    }

    private void validateDeleted(String resource, int sourceVersionCount, List<OcflVersionInfo> versions, ValidationHandler.ValidationResultBuilder builder) {
        String version = "version " + sourceVersionCount;
        String success = "%s is marked as deleted";
        String failure = "%s is not marked as deleted in Fedora 6 OCFL";
        String error = "Deleted object for %s does not exist in Fedora 6 OCFL";
        try {
            OcflVersionInfo versionInfo = versions.get(sourceVersionCount + 1);
            ResourceHeaders headers = this.ocflSession.readHeaders(resource, versionInfo.getVersionNumber());
            if (headers.isDeleted()) {
                this.validationResults.add(builder.ok(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_DELETED, String.format("%s is marked as deleted", version)));
            } else {
                this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_DELETED, String.format("%s is not marked as deleted in Fedora 6 OCFL", version)));
            }
        }
        catch (IndexOutOfBoundsException | NotFoundException ex) {
            this.validationResults.add(builder.fail(ValidationResult.ValidationType.SOURCE_OBJECT_RESOURCE_DELETED, String.format("Deleted object for %s does not exist in Fedora 6 OCFL", version)));
        }
    }

    private void completeObjectValidation() {
        String pid = this.objectInfo.getPid();
        String ocflId = this.ocflSession.ocflObjectId();
        String nonRdfSource = "http://www.w3.org/ns/ldp#NonRDFSource";
        long ocflResourceCount = this.ocflSession.streamResourceHeaders().filter(r -> !r.isDeleted() && r.getInteractionModel().equals("http://www.w3.org/ns/ldp#NonRDFSource")).count();
        ValidationResult.Status result = (long)this.headDatastreamIds.size() == ocflResourceCount ? ValidationResult.Status.OK : ValidationResult.Status.FAIL;
        String details = (long)this.headDatastreamIds.size() == ocflResourceCount ? "The number of binary objects in HEAD are identical." : String.format("The number of binary object in HEAD are not equal: f3-> %d vs f6-> %d", this.headDatastreamIds.size(), ocflResourceCount);
        this.validationResults.add(new ValidationResult(this.index.getAndIncrement(), result, ValidationResult.ValidationLevel.OBJECT, ValidationResult.ValidationType.BINARY_HEAD_COUNT, pid, ocflId, details));
    }
}

