/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.api;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.fcrepo.migration.validator.api.ValidationResult;

public class ObjectValidationResults {
    private final List<ValidationResult> results;

    public ObjectValidationResults(List<ValidationResult> results) {
        this.results = results;
    }

    public String getObjectId() {
        if (this.results == null || this.results.isEmpty()) {
            return "unknown";
        }
        return this.results.stream().findFirst().map(ValidationResult::getSourceObjectId).orElse("unknown");
    }

    public String getEncodedObjectId() {
        if (this.results == null || this.results.isEmpty()) {
            return "unknown";
        }
        return this.results.stream().findFirst().map(ValidationResult::getSourceObjectId).map(objectId -> URLEncoder.encode(objectId, Charset.defaultCharset())).orElse("unknown");
    }

    public boolean hasErrors() {
        if (this.results == null || this.results.isEmpty()) {
            return false;
        }
        for (ValidationResult vr : this.results) {
            if (!vr.getStatus().equals((Object)ValidationResult.Status.FAIL)) continue;
            return true;
        }
        return false;
    }

    public List<ValidationResult> getResults() {
        return this.results;
    }

    public List<ValidationResult> getPassed() {
        return this.results.stream().filter(result -> result.getStatus().equals((Object)ValidationResult.Status.OK)).collect(Collectors.toList());
    }

    public List<ValidationResult> getErrors() {
        return this.results.stream().filter(result -> result.getStatus().equals((Object)ValidationResult.Status.FAIL)).collect(Collectors.toList());
    }
}

