/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Suppliers;
import io.ocfl.api.MutableOcflRepository;
import io.ocfl.api.OcflRepository;
import io.ocfl.api.util.Enforce;
import io.ocfl.core.OcflRepositoryBuilder;
import io.ocfl.core.extension.OcflExtensionConfig;
import io.ocfl.core.extension.storage.layout.config.HashedNTupleLayoutConfig;
import io.ocfl.core.path.mapper.LogicalPathMapper;
import io.ocfl.core.path.mapper.LogicalPathMappers;
import io.ocfl.core.storage.OcflStorage;
import io.ocfl.core.storage.OcflStorageBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.fcrepo.migration.ObjectSource;
import org.fcrepo.migration.foxml.AkubraFSIDResolver;
import org.fcrepo.migration.foxml.ArchiveExportedFoxmlDirectoryObjectSource;
import org.fcrepo.migration.foxml.InternalIDResolver;
import org.fcrepo.migration.foxml.LegacyFSIDResolver;
import org.fcrepo.migration.foxml.NativeFoxmlDirectoryObjectSource;
import org.fcrepo.migration.validator.api.ObjectValidationConfig;
import org.fcrepo.migration.validator.api.ResumeManager;
import org.fcrepo.migration.validator.api.ValidationResultWriter;
import org.fcrepo.migration.validator.impl.Fedora3ValidationConfig;
import org.fcrepo.migration.validator.impl.FileSystemValidationResultWriter;
import org.fcrepo.migration.validator.impl.ResumeManagerImpl;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.DefaultOcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.cache.CaffeineCache;

public class ApplicationConfigurationHelper {
    private final Fedora3ValidationConfig config;
    private final Path workDirectory;
    private final ResumeManager resumeManager;
    private final Supplier<MutableOcflRepository> repositorySupplier;

    public ApplicationConfigurationHelper(Fedora3ValidationConfig config) {
        this.config = config;
        try {
            this.workDirectory = Files.createTempDirectory("ocfl-work", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.repositorySupplier = Suppliers.memoize(() -> this.repository(config, this.workDirectory));
        this.resumeManager = new ResumeManagerImpl(config.getResultsDirectory(), !config.isResume());
    }

    public ResumeManager resumeManager() {
        return this.resumeManager;
    }

    public ValidationResultWriter validationResultWriter() {
        return new FileSystemValidationResultWriter(this.config.getJsonOutputDirectory(), this.config.isFailureOnly());
    }

    public ObjectSource objectSource() {
        try {
            return this.doObjectSource();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectSource doObjectSource() throws IOException {
        ArchiveExportedFoxmlDirectoryObjectSource objectSource;
        File f3ExportedDir = this.config.getExportedDirectory();
        File f3DatastreamsDir = this.config.getDatastreamsDirectory();
        File f3ObjectsDir = this.config.getObjectsDirectory();
        File indexDir = this.config.getIndexDirectory();
        String f3hostname = this.config.getFedora3Hostname();
        switch (this.config.getSourceType()) {
            case EXPORTED: {
                Enforce.notNull((Object)this.config.getExportedDirectory(), (String)"f3ExportDir must be used with 'exported' source!");
                objectSource = new ArchiveExportedFoxmlDirectoryObjectSource(f3ExportedDir, f3hostname);
                break;
            }
            case AKUBRA: {
                Enforce.notNull((Object)f3DatastreamsDir, (String)"f3DatastreamsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.notNull((Object)f3ObjectsDir, (String)"f3ObjectsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.expressionTrue((boolean)f3ObjectsDir.exists(), (Object)f3ObjectsDir, (String)("f3ObjectsDir must exist! " + f3ObjectsDir.getAbsolutePath()));
                AkubraFSIDResolver idResolver = new AkubraFSIDResolver(indexDir, f3DatastreamsDir);
                objectSource = new NativeFoxmlDirectoryObjectSource(f3ObjectsDir, (InternalIDResolver)idResolver, f3hostname);
                break;
            }
            case LEGACY: {
                Enforce.notNull((Object)f3DatastreamsDir, (String)"f3DatastreamsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.notNull((Object)f3ObjectsDir, (String)"f3ObjectsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.expressionTrue((boolean)f3ObjectsDir.exists(), (Object)f3ObjectsDir, (String)("f3ObjectsDir must exist! " + f3ObjectsDir.getAbsolutePath()));
                LegacyFSIDResolver idResolver = new LegacyFSIDResolver(indexDir, f3DatastreamsDir);
                objectSource = new NativeFoxmlDirectoryObjectSource(f3ObjectsDir, (InternalIDResolver)idResolver, f3hostname);
                break;
            }
            default: {
                throw new RuntimeException("Should never happen");
            }
        }
        return objectSource;
    }

    private MutableOcflRepository repository(Fedora3ValidationConfig config, Path workDir) {
        OcflStorage storage = OcflStorageBuilder.builder().fileSystem(config.getOcflRepositoryRootDirectory().toPath()).build();
        LogicalPathMapper logicalPathMapper = SystemUtils.IS_OS_WINDOWS ? LogicalPathMappers.percentEncodingWindowsMapper() : LogicalPathMappers.percentEncodingLinuxMapper();
        return new OcflRepositoryBuilder().storage(storage).defaultLayoutConfig((OcflExtensionConfig)new HashedNTupleLayoutConfig()).logicalPathMapper(logicalPathMapper).workDir(workDir).buildMutable();
    }

    public OcflRepository ocflRepository() {
        return (OcflRepository)this.repositorySupplier.get();
    }

    public OcflObjectSessionFactory ocflObjectSessionFactory() {
        ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Cache headersCache = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(Duration.ofMinutes(10L)).build();
        Cache rootIdCache = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(Duration.ofMinutes(10L)).build();
        return new DefaultOcflObjectSessionFactory(this.repositorySupplier.get(), this.workDirectory, objectMapper, (org.fcrepo.storage.ocfl.cache.Cache)new CaffeineCache(headersCache), (org.fcrepo.storage.ocfl.cache.Cache)new CaffeineCache(rootIdCache), CommitType.UNVERSIONED, "Authored by Fedora 6", "fedoraAdmin", "info:fedora/fedoraAdmin");
    }

    public Set<String> readObjectsToValidate() {
        File file = this.config.getObjectsToValidate();
        HashSet<String> objectIds = new HashSet<String>();
        if (file != null) {
            try (Stream<String> lines = Files.lines(file.toPath());){
                lines.forEach(objectIds::add);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return objectIds;
    }

    public int getThreadCount() {
        return this.config.getThreadCount();
    }

    public int getLimit() {
        return this.config.getLimit();
    }

    public ObjectValidationConfig getObjectValidationConfig() {
        return new ObjectValidationConfig(this.config.getOcflRepositoryRootDirectory(), this.config.enableChecksums(), this.config.isDeleteInactive(), this.config.validateHeadOnly(), (OcflRepository)this.repositorySupplier.get(), this.config.getDigestAlgorithm());
    }

    public Boolean checkNumObjects() {
        return this.config.checkNumObjects();
    }
}

