/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import io.ocfl.api.OcflRepository;
import java.util.List;
import java.util.Optional;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.ValidationResultWriter;
import org.fcrepo.migration.validator.api.ValidationTask;
import org.fcrepo.migration.validator.impl.ApplicationConfigurationHelper;
import org.fcrepo.migration.validator.impl.F3RepositoryValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class F3RepositoryValidationTask
extends ValidationTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(F3RepositoryValidationTask.class);
    private final ValidationResultWriter writer;
    private final ApplicationConfigurationHelper config;

    public F3RepositoryValidationTask(ApplicationConfigurationHelper config, ValidationResultWriter writer) {
        this.config = config;
        this.writer = writer;
    }

    @Override
    public ValidationTask get() {
        LOGGER.info("Starting repository processor");
        OcflRepository repository = this.config.ocflRepository();
        F3RepositoryValidator repositoryValidator = new F3RepositoryValidator(this.config);
        List<ValidationResult> results = repositoryValidator.validate(repository);
        this.writer.write(results);
        return this;
    }

    @Override
    public Optional<String> getPid() {
        return Optional.empty();
    }
}

