/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import io.ocfl.api.OcflRepository;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.ObjectSource;
import org.fcrepo.migration.validator.api.RepositoryValidator;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.impl.ApplicationConfigurationHelper;
import org.fcrepo.migration.validator.impl.F3State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class F3RepositoryValidator
implements RepositoryValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(F3RepositoryValidator.class);
    private long deleted = 0L;
    private long objects = 0L;
    private final boolean headOnly;
    private final boolean enableCheckNumObjects;
    private final AtomicInteger index;
    private final boolean deleteInactive;
    private final ObjectSource source;
    private final List<ValidationResult> validationResults = new ArrayList<ValidationResult>();

    public F3RepositoryValidator(ApplicationConfigurationHelper config) {
        this.index = new AtomicInteger(0);
        this.source = config.objectSource();
        this.enableCheckNumObjects = config.checkNumObjects();
        this.headOnly = config.getObjectValidationConfig().isValidateHeadOnly();
        this.deleteInactive = config.getObjectValidationConfig().deleteInactive();
    }

    @Override
    public List<ValidationResult> validate(OcflRepository repository) {
        if (this.enableCheckNumObjects) {
            try {
                this.countF3();
                this.checkObjects(repository);
            }
            catch (IOException e) {
                LOGGER.error("Error getting Fedora3 repository count", (Throwable)e);
            }
        }
        return this.validationResults;
    }

    private void checkObjects(OcflRepository ocflRepository) {
        String success = "Repository object counts match: Total=%s";
        String error = "Repository object counts do not match: sourceValue=%s, targetValue=%s";
        try (Stream ocflIds = ocflRepository.listObjectIds();){
            long ocflCount = ocflIds.count();
            long f3Count = this.headOnly ? this.objects - this.deleted : this.objects;
            ValidationResult result = ocflCount == f3Count ? new ValidationResult(this.index.getAndIncrement(), ValidationResult.Status.OK, ValidationResult.ValidationLevel.REPOSITORY, ValidationResult.ValidationType.REPOSITORY_RESOURCE_COUNT, String.format("Repository object counts match: Total=%s", f3Count)) : new ValidationResult(this.index.getAndIncrement(), ValidationResult.Status.FAIL, ValidationResult.ValidationLevel.REPOSITORY, ValidationResult.ValidationType.REPOSITORY_RESOURCE_COUNT, String.format("Repository object counts do not match: sourceValue=%s, targetValue=%s", this.objects, f3Count));
            this.validationResults.add(result);
        }
    }

    private void countF3() throws IOException {
        for (FedoraObjectProcessor processor : this.source) {
            ++this.objects;
            Path xml = processor.getObjectInfo().getFoxmlPath();
            FedoraObjectProcessor fedoraObjectProcessor = processor;
            try {
                Stream<String> lines = Files.lines(xml);
                try {
                    lines.filter(line -> line.contains("info:fedora/fedora-system:def/model#state")).findFirst().ifPresent(this::testDeleted);
                }
                finally {
                    if (lines == null) continue;
                    lines.close();
                }
            }
            finally {
                if (fedoraObjectProcessor == null) continue;
                fedoraObjectProcessor.close();
            }
        }
    }

    private void testDeleted(String xml) {
        F3State state;
        Pattern pattern = Pattern.compile("value=\"(.*)\"", 2);
        Matcher matcher = pattern.matcher(xml);
        if (matcher.find() && (state = F3State.fromString(matcher.group(1))).isDeleted(this.deleteInactive)) {
            ++this.deleted;
        }
    }
}

