/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.function.UnaryOperator;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.ValidationResultWriter;
import org.fcrepo.migration.validator.impl.ValidationResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemValidationResultWriter
implements ValidationResultWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemValidationResultWriter.class);
    private final Path validationRoot;
    private final boolean writeFailureOnly;
    private final UnaryOperator<String> pathEncoder;

    public FileSystemValidationResultWriter(Path validationRoot, boolean writeFailureOnly) {
        this.validationRoot = validationRoot;
        this.writeFailureOnly = writeFailureOnly;
        validationRoot.toFile().mkdirs();
        this.pathEncoder = original -> URLEncoder.encode(original, Charset.defaultCharset());
    }

    @Override
    public void write(List<ValidationResult> results) {
        ObjectMapper objectMapper = new ObjectMapper();
        for (ValidationResult result : results) {
            if (result.getStatus() == ValidationResult.Status.OK && this.writeFailureOnly) continue;
            Path jsonFilePath = this.validationRoot.resolve(ValidationResultUtils.resolvePathToJsonResult(result, this.pathEncoder));
            LOGGER.debug("Writing of results here: {}", (Object)jsonFilePath);
            File file = jsonFilePath.toFile();
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                String resultStr = objectMapper.writeValueAsString((Object)result);
                writer.write(resultStr);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

