/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Stream;
import org.fcrepo.migration.validator.api.ResumeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeManagerImpl
implements ResumeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResumeManagerImpl.class);
    private final boolean acceptAll;
    private final Path resumeFile;
    private final Set<String> processedPids;

    public ResumeManagerImpl(Path resultsDir, boolean acceptAll) {
        this.acceptAll = acceptAll;
        this.resumeFile = resultsDir.resolve("resume.txt");
        this.processedPids = new ConcurrentSkipListSet<String>();
        try {
            this.loadResumeFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadResumeFile() throws IOException {
        if (!Files.exists(this.resumeFile, new LinkOption[0])) {
            Files.createDirectories(this.resumeFile.getParent(), new FileAttribute[0]);
            Files.createFile(this.resumeFile, new FileAttribute[0]);
        }
        try (Stream<String> lines = Files.lines(this.resumeFile);){
            lines.forEach(this.processedPids::add);
        }
    }

    @Override
    public void updateResumeFile() {
        String lineSeparator = System.lineSeparator();
        try (BufferedWriter writer = Files.newBufferedWriter(this.resumeFile, StandardOpenOption.TRUNCATE_EXISTING);){
            for (String pid : this.processedPids) {
                writer.write(pid + lineSeparator);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void completed(String pid) {
        this.processedPids.add(pid);
    }

    @Override
    public boolean accept(String pid) {
        String logMsg = "PID: {}, accept? {}";
        if (!this.acceptAll && this.processedPids.contains(pid)) {
            LOGGER.debug("PID: {}, accept? {}", (Object)pid, (Object)false);
            return false;
        }
        LOGGER.debug("PID: {}, accept? {}", (Object)pid, (Object)true);
        return true;
    }
}

