/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.impl;

import com.google.common.base.Splitter;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.migration.validator.api.ValidationResult;

public class ValidationResultUtils {
    private ValidationResultUtils() {
    }

    public static Path resolvePathToJsonResult(ValidationResult result, UnaryOperator<String> pathEncoder) {
        ArrayList pathSegments = new ArrayList();
        String sourceId = result.getSourceObjectId();
        if (sourceId != null) {
            List segments = Splitter.fixedLength((int)4).splitToList((CharSequence)DigestUtils.sha1Hex((String)sourceId)).subList(0, 4);
            pathSegments.addAll(segments);
            pathSegments.add((String)pathEncoder.apply(sourceId));
        }
        pathSegments.add("result-" + result.getIndex() + ".json");
        return Path.of(String.join((CharSequence)File.separator, pathSegments), new String[0]);
    }
}

