/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.fcrepo.migration.validator.api.ObjectReportSummary;
import org.fcrepo.migration.validator.api.ObjectValidationResults;
import org.fcrepo.migration.validator.api.ReportHandler;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.ValidationResultsSummary;
import org.fcrepo.migration.validator.report.ReportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReportHandler
implements ReportHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvReportHandler.class);
    private final Path outputDir;
    private final ReportType reportType;

    public CsvReportHandler(Path outputDir, ReportType reportType) {
        if (reportType == ReportType.html) {
            throw new IllegalArgumentException("Invalid report type given, must be csv or tsv");
        }
        this.outputDir = outputDir;
        this.reportType = reportType;
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void beginReport() {
    }

    @Override
    public String objectLevelReport(ObjectValidationResults objectValidationResults) {
        Path csvFile = this.outputDir.resolve(objectValidationResults.getEncodedObjectId() + this.reportType.getExtension());
        return this.writeValidationResults(csvFile, objectValidationResults);
    }

    @Override
    public String validationSummary(ValidationResultsSummary validationSummary) {
        CsvMapper mapper = new CsvMapper();
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;
        Path csvFile = this.outputDir.resolve("migration-validation-summary" + LocalDate.now().format(formatter) + this.reportType.getExtension());
        CsvSchema schema = mapper.schemaFor(ObjectReportSummary.class).withHeader().withColumnSeparator(this.reportType.getSeparator().charValue());
        try (BufferedWriter fileWriter = Files.newBufferedWriter(csvFile, new OpenOption[0]);
             SequenceWriter csvWriter = mapper.writer((FormatSchema)schema).writeValues((Writer)fileWriter);){
            csvWriter.writeAll(validationSummary.getObjectReports());
        }
        catch (IOException ex) {
            LOGGER.error("Unable to write report {}", (Object)csvFile.getFileName(), (Object)ex);
            throw new RuntimeException(ex);
        }
        return csvFile.toString();
    }

    @Override
    public String repositoryLevelReport(ObjectValidationResults objectValidationResults) {
        Path csvFile = this.outputDir.resolve("repository" + this.reportType.getExtension());
        return this.writeValidationResults(csvFile, objectValidationResults);
    }

    private String writeValidationResults(Path file, ObjectValidationResults objectValidationResults) {
        CsvMapper mapper = (CsvMapper)((CsvMapper.Builder)CsvMapper.builder().addMixIn(ValidationResult.class, ValidationResultMixin.class)).build();
        CsvSchema schema = mapper.schemaFor(ValidationResult.class).withHeader().withColumnSeparator(this.reportType.getSeparator().charValue());
        try (BufferedWriter fileWriter = Files.newBufferedWriter(file, new OpenOption[0]);
             SequenceWriter csvWriter = mapper.writer((FormatSchema)schema).writeValues((Writer)fileWriter);){
            csvWriter.writeAll(objectValidationResults.getResults());
        }
        catch (IOException e) {
            LOGGER.error("Unable to write report {}", (Object)file.getFileName(), (Object)e);
            throw new RuntimeException(e);
        }
        return file.toString();
    }

    @Override
    public void endReport() {
    }

    @JsonPropertyOrder(value={"status", "validationLevel", "validationType", "details", "sourceObjectId", "sourceResourceId", "targetObjectId", "targetResourceId"})
    public static abstract class ValidationResultMixin {
        @JsonIgnore
        abstract int getIndex();
    }
}

