/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.validator.report;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.fcrepo.migration.validator.api.ObjectReportSummary;
import org.fcrepo.migration.validator.api.ObjectValidationResults;
import org.fcrepo.migration.validator.api.ReportHandler;
import org.fcrepo.migration.validator.api.ValidationResult;
import org.fcrepo.migration.validator.api.ValidationResultsSummary;
import org.fcrepo.migration.validator.impl.FileSystemValidationResultReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGeneratorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportGeneratorImpl.class);
    private Path resultDir;
    private ReportHandler reportHandler;
    private ValidationResultsSummary summary;

    public ReportGeneratorImpl(Path resultDir, ReportHandler reportHandler) {
        this.resultDir = resultDir;
        this.reportHandler = reportHandler;
        this.summary = new ValidationResultsSummary();
    }

    public String generate() {
        this.reportHandler.beginReport();
        String reportFilename = this.processResults();
        this.reportHandler.endReport();
        return reportFilename;
    }

    private String processResults() {
        try {
            return this.doProcessResults();
        }
        catch (IOException e) {
            LOGGER.error("Unable to write report", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String doProcessResults() throws IOException {
        Files.walkFileTree(this.resultDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                int depth = file.getNameCount() - ReportGeneratorImpl.this.resultDir.getNameCount();
                File parent = file.getParent().toFile();
                String objectId = parent.getName();
                if (depth > 1 && !ReportGeneratorImpl.this.summary.containsReport(objectId) && ReportGeneratorImpl.this.isValidationResultFile(file.toFile().getName())) {
                    ObjectReportSummary reportSummary = ReportGeneratorImpl.this.loadValidationResults(parent, ReportGeneratorImpl.this.reportHandler::objectLevelReport);
                    ReportGeneratorImpl.this.summary.addObjectReport(objectId, reportSummary);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        ObjectReportSummary repositoryReport = this.loadValidationResults(this.resultDir.toFile(), this.reportHandler::repositoryLevelReport);
        this.summary.addRepositoryReport(repositoryReport);
        return this.reportHandler.validationSummary(this.summary);
    }

    private boolean isValidationResultFile(String filename) {
        return FilenameUtils.getExtension((String)filename).equalsIgnoreCase("json") && filename.startsWith("result-");
    }

    private ObjectReportSummary loadValidationResults(File objectDir, Function<ObjectValidationResults, String> reportHandler) {
        LOGGER.debug("Loading validation results from: {}", (Object)objectDir);
        FilenameFilter filter = (dir, name) -> this.isValidationResultFile(name);
        FileSystemValidationResultReader reader = new FileSystemValidationResultReader();
        ArrayList<ValidationResult> resultsList = new ArrayList<ValidationResult>();
        for (File f : Objects.requireNonNull(objectDir.listFiles(filter))) {
            resultsList.add(reader.read(f));
        }
        resultsList.sort(Comparator.comparingInt(ValidationResult::getIndex));
        ObjectValidationResults validationResults = new ObjectValidationResults(resultsList);
        String reportFilename = reportHandler.apply(validationResults);
        LOGGER.info("Finished report {}", (Object)reportFilename);
        return new ObjectReportSummary(validationResults.hasErrors(), validationResults.getObjectId(), reportFilename);
    }
}

