/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Session;
import org.fcrepo.auth.roles.common.AbstractRolesAuthorizationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebACAuthorizationDelegate
extends AbstractRolesAuthorizationDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebACAuthorizationDelegate.class);
    private static final Map<String, String> actionMap;
    private static final Principal EVERYONE;

    public boolean rolesHavePermission(Session userSession, String absPath, String[] actions, Set<String> roles) {
        boolean permit = !Arrays.asList(actions).stream().map(actionMap::get).filter(x -> !roles.contains(x)).findFirst().isPresent();
        LOGGER.debug("Request for actions: {}, on path: {}, with roles: {}. Permission={}", new Object[]{actions, absPath, roles, permit});
        return permit;
    }

    public Principal getEveryonePrincipal() {
        return EVERYONE;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("read", "http://www.w3.org/ns/auth/acl#Read");
        map.put("add_node", "http://www.w3.org/ns/auth/acl#Write");
        map.put("register_namespace", "http://www.w3.org/ns/auth/acl#Write");
        map.put("remove", "http://www.w3.org/ns/auth/acl#Write");
        map.put("remove_child_nodes", "http://www.w3.org/ns/auth/acl#Write");
        map.put("set_property", "http://www.w3.org/ns/auth/acl#Write");
        map.put("modify_access_control", "http://www.w3.org/ns/auth/acl#Control");
        map.put("read_access_control", "http://www.w3.org/ns/auth/acl#Control");
        actionMap = Collections.unmodifiableMap(map);
        EVERYONE = new Principal(){

            @Override
            public String getName() {
                return "http://xmlns.com/foaf/0.1/Agent";
            }

            @Override
            public String toString() {
                return this.getName();
            }
        };
    }
}

