/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.tuple.Pair;
import org.fcrepo.auth.roles.common.AccessRolesProvider;
import org.fcrepo.auth.webac.URIConstants;
import org.fcrepo.auth.webac.WebACAuthorization;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.NodeService;
import org.fcrepo.kernel.api.utils.UncheckedFunction;
import org.fcrepo.kernel.modeshape.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.modeshape.rdf.impl.PropertiesRdfContext;
import org.modeshape.jcr.value.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

class WebACRolesProvider
implements AccessRolesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebACRolesProvider.class);
    private static final String FEDORA_INTERNAL_PREFIX = "info:fedora";
    private static final List<String> EMPTY = Collections.unmodifiableList(new ArrayList());
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SessionFactory sessionFactory;
    private Function<List<String>, Predicate<WebACAuthorization>> accessToClass = uris -> x -> uris.stream().distinct().filter(y -> x.getAccessToClassURIs().contains(y)).findFirst().isPresent();
    private Function<List<String>, Predicate<WebACAuthorization>> accessTo = uris -> x -> uris.stream().distinct().filter(y -> x.getAccessToURIs().contains(y)).findFirst().isPresent();
    final Predicate<Property> isAclPredicate = p -> !p.isAnon() && p.getNameSpace().startsWith("http://www.w3.org/ns/auth/acl#");

    WebACRolesProvider() {
    }

    public void postRoles(Node node, Map<String, Set<String>> data) throws RepositoryException {
        throw new UnsupportedOperationException("postRoles() is not implemented");
    }

    public void deleteRoles(Node node) throws RepositoryException {
        throw new UnsupportedOperationException("deleteRoles() is not implemented");
    }

    public Map<String, List<String>> findRolesForPath(Path absPath, Session session) throws RepositoryException {
        LOGGER.debug("findRolesForPath: {}", (Object)absPath.getString());
        return this.getAgentRoles((FedoraResource)this.nodeService.find(session, absPath.getString()));
    }

    public Map<String, List<String>> getRoles(Node node, boolean effective) {
        return this.getAgentRoles((FedoraResource)this.nodeService.cast(node));
    }

    private Map<String, List<String>> getAgentRoles(FedoraResource resource) {
        LOGGER.debug("Getting agent roles for: {}", (Object)resource.getPath());
        Optional<Pair<URI, FedoraResource>> effectiveAcl = WebACRolesProvider.getEffectiveAcl(resource);
        ArrayList<String> resourcePaths = new ArrayList<String>();
        resourcePaths.add(FEDORA_INTERNAL_PREFIX + resource.getPath());
        List rdfTypes = resource.getTypes();
        effectiveAcl.map(x -> (FedoraResource)x.getRight()).filter(x -> !x.getPath().equals(resource.getPath())).ifPresent(x -> {
            resourcePaths.add(FEDORA_INTERNAL_PREFIX + x.getPath());
            rdfTypes.addAll(x.getTypes());
        });
        Predicate<WebACAuthorization> checkAccessTo = this.accessTo.apply(resourcePaths);
        Predicate<WebACAuthorization> checkAccessToClass = this.accessToClass.apply(rdfTypes.stream().map(URI::toString).collect(Collectors.toList()));
        List authorizations = effectiveAcl.map(UncheckedFunction.uncheck(x -> this.getAuthorizations(((URI)x.getLeft()).toString()))).orElse(new ArrayList());
        HashMap effectiveRoles = new HashMap();
        authorizations.stream().filter(x -> checkAccessTo.test((WebACAuthorization)x) || checkAccessToClass.test((WebACAuthorization)x)).forEach(x -> x.getAgents().stream().forEach(y -> {
            effectiveRoles.putIfAbsent(y, new HashSet());
            ((Set)effectiveRoles.get(y)).addAll(x.getModes().stream().map(URI::toString).collect(Collectors.toList()));
        }));
        LOGGER.debug("Unfiltered ACL: {}", effectiveRoles);
        return effectiveRoles.entrySet().stream().map(x -> new AbstractMap.SimpleEntry(x.getKey(), new ArrayList((Collection)x.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<WebACAuthorization> getAuthorizations(String location) {
        Session internalSession = this.sessionFactory.getInternalSession();
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(internalSession);
        Model model = ModelFactory.createDefaultModel();
        LOGGER.debug("Effective ACL: {}", (Object)location);
        if (location.startsWith(FEDORA_INTERNAL_PREFIX)) {
            FedoraResource resource = (FedoraResource)this.nodeService.find(internalSession, location.substring(FEDORA_INTERNAL_PREFIX.length()));
            resource.getChildren().forEachRemaining(arg_0 -> this.lambda$getAuthorizations$17((IdentifierConverter)translator, model, authorizations, arg_0));
        }
        return authorizations;
    }

    private static WebACAuthorization createAuthorizationFromMap(Map<String, List<String>> data) {
        return new WebACAuthorization((Collection<String>)data.getOrDefault("http://www.w3.org/ns/auth/acl#agent", EMPTY), (Collection<String>)data.getOrDefault("http://www.w3.org/ns/auth/acl#agentClass", EMPTY), data.getOrDefault("http://www.w3.org/ns/auth/acl#mode", EMPTY).stream().map(URI::create).collect(Collectors.toList()), (Collection<String>)data.getOrDefault("http://www.w3.org/ns/auth/acl#accessTo", EMPTY), (Collection<String>)data.getOrDefault("http://www.w3.org/ns/auth/acl#accessToClass", EMPTY));
    }

    private static Optional<Pair<URI, FedoraResource>> getEffectiveAcl(FedoraResource resource) {
        try {
            DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(resource.getNode().getSession());
            ArrayList acls = new ArrayList();
            Model model = ModelFactory.createDefaultModel();
            resource.getTriples((IdentifierConverter)translator, PropertiesRdfContext.class).filter(t -> model.asStatement(t).getPredicate().hasURI("http://www.w3.org/ns/auth/acl#accessControl")).filter(t -> t.getObject().isURI()).forEachRemaining(t -> acls.add(t.getObject().getURI()));
            if (!acls.isEmpty()) {
                if (acls.size() > 1) {
                    LOGGER.warn("Found multiple ACLs defined for this node. Using: {}", acls.get(0));
                }
                return Optional.of(Pair.of((Object)URI.create((String)acls.get(0)), (Object)resource));
            }
            if (resource.getNode().getDepth() == 0) {
                LOGGER.debug("No ACLs defined on this node or in parent hierarchy");
                return Optional.empty();
            }
            LOGGER.trace("Checking parent resource for ACL. No ACL found at {}", (Object)resource.getPath());
            return WebACRolesProvider.getEffectiveAcl(resource.getContainer());
        }
        catch (RepositoryException ex) {
            LOGGER.debug("Exception finding effective ACL: {}", (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    private /* synthetic */ void lambda$getAuthorizations$17(IdentifierConverter identifierConverter, Model model, List list, FedoraResource child) {
        if (child.getTypes().contains(URIConstants.WEBAC_AUTHORIZATION)) {
            HashMap<String, List<String>> aclTriples = new HashMap<String, List<String>>();
            child.getTriples(identifierConverter, PropertiesRdfContext.class).filter(p -> this.isAclPredicate.test(model.asStatement(p).getPredicate())).forEachRemaining(t -> {
                aclTriples.putIfAbsent(t.getPredicate().getURI(), new ArrayList());
                if (t.getObject().isURI()) {
                    ((List)aclTriples.get(t.getPredicate().getURI())).add(t.getObject().getURI());
                } else if (t.getObject().isLiteral()) {
                    ((List)aclTriples.get(t.getPredicate().getURI())).add(t.getObject().getLiteralValue().toString());
                }
            });
            LOGGER.debug("Adding acl:Authorization from {}", (Object)child.getPath());
            list.add(WebACRolesProvider.createAuthorizationFromMap(aclTriples));
        }
    }
}

