/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import javax.jcr.Session;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.UriAwareHttpHeaderFactory;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.NodeService;
import org.fcrepo.kernel.modeshape.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.modeshape.rdf.impl.PropertiesRdfContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkHeaderProvider
implements UriAwareHttpHeaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkHeaderProvider.class);
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private NodeService nodeService;

    public Multimap<String, String> createHttpHeadersForResource(UriInfo uriInfo, FedoraResource resource) {
        Session internalSession = this.sessionFactory.getInternalSession();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(internalSession);
        Model model = ModelFactory.createDefaultModel();
        ArrayListMultimap headers = ArrayListMultimap.create();
        LOGGER.debug("Adding WebAC Link Header for Resource: {}", (Object)resource);
        ((FedoraResource)this.nodeService.find(internalSession, resource.getPath())).getTriples((IdentifierConverter)translator, PropertiesRdfContext.class).filter(t -> model.asStatement(t).getPredicate().hasURI("http://www.w3.org/ns/auth/acl#accessControl")).filter(t -> t.getObject().isURI()).forEachRemaining(arg_0 -> LinkHeaderProvider.lambda$createHttpHeadersForResource$3((ListMultimap)headers, uriInfo, (IdentifierConverter)translator, model, arg_0));
        return headers;
    }

    private static /* synthetic */ void lambda$createHttpHeadersForResource$3(ListMultimap headers, UriInfo uriInfo, IdentifierConverter translator, Model model, Triple t) {
        headers.put((Object)"Link", (Object)Link.fromUri((String)uriInfo.getBaseUriBuilder().path(((FedoraResource)translator.convert((Object)model.asStatement(t).getObject().asResource())).getPath()).toString()).rel("acl").build(new Object[0]).toString());
    }
}

