/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jena.riot.Lang;
import org.fcrepo.auth.roles.common.AccessRolesProvider;
import org.fcrepo.auth.webac.URIConstants;
import org.fcrepo.auth.webac.WebACAuthorization;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.api.services.NodeService;
import org.fcrepo.kernel.modeshape.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.modeshape.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.modeshape.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.modeshape.utils.FedoraTypesUtils;
import org.fcrepo.kernel.modeshape.utils.UncheckedFunction;
import org.fcrepo.kernel.modeshape.utils.UncheckedPredicate;
import org.modeshape.jcr.value.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WebACRolesProvider
implements AccessRolesProvider {
    public static final String ROOT_AUTHORIZATION_PROPERTY = "fcrepo.auth.webac.authorization";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebACRolesProvider.class);
    private static final List<String> EMPTY = Collections.unmodifiableList(new ArrayList());
    private static final String FEDORA_INTERNAL_PREFIX = "info:fedora";
    private static final String ROOT_AUTHORIZATION_LOCATION = "/root-authorization.ttl";
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SessionFactory sessionFactory;
    private Function<List<String>, Predicate<WebACAuthorization>> accessToClass = uris -> x -> uris.stream().distinct().filter(y -> x.getAccessToClassURIs().contains(y)).findFirst().isPresent();
    private Function<List<String>, Predicate<WebACAuthorization>> accessTo = uris -> x -> uris.stream().distinct().filter(y -> x.getAccessToURIs().contains(y)).findFirst().isPresent();
    final Function<List<URI>, Predicate<Property>> memberTestFromTypes = types -> {
        HashSet typeLookup = new HashSet(types);
        return p -> !p.isAnon() && typeLookup.contains(URIConstants.FOAF_GROUP) && p.getURI().equals("http://xmlns.com/foaf/0.1/member");
    };
    static final Predicate<Property> isAclPredicate = p -> !p.isAnon() && p.getNameSpace().startsWith("http://www.w3.org/ns/auth/acl#");

    public void postRoles(Node node, Map<String, Set<String>> data) throws RepositoryException {
        throw new UnsupportedOperationException("postRoles() is not implemented");
    }

    public void deleteRoles(Node node) throws RepositoryException {
        throw new UnsupportedOperationException("deleteRoles() is not implemented");
    }

    public Map<String, List<String>> findRolesForPath(Path absPath, Session session) throws RepositoryException {
        return this.getAgentRoles(this.locateResource(absPath, session));
    }

    private FedoraResource locateResource(Path path, Session session) {
        UncheckedPredicate exists = UncheckedPredicate.uncheck(x -> session.nodeExists(x.toString()));
        if (exists.test(path) || path.isRoot()) {
            LOGGER.debug("findRolesForPath: {}", (Object)path.getString());
            return (FedoraResource)this.nodeService.find(session, path.toString());
        }
        LOGGER.trace("Path: {} does not exist, checking parent", (Object)path.getString());
        return this.locateResource(path.getParent(), session);
    }

    public Map<String, List<String>> getRoles(Node node, boolean effective) {
        return this.getAgentRoles((FedoraResource)this.nodeService.cast(node));
    }

    private Map<String, List<String>> getAgentRoles(FedoraResource resource) {
        LOGGER.debug("Getting agent roles for: {}", (Object)resource.getPath());
        Optional<Pair<URI, FedoraResource>> effectiveAcl = WebACRolesProvider.getEffectiveAcl((FedoraResource)(FedoraTypesUtils.isNonRdfSourceDescription.test(resource.getNode()) ? ((NonRdfSourceDescription)NodeResourceConverter.nodeConverter.convert((Object)resource.getNode())).getDescribedResource() : resource));
        ArrayList<String> resourcePaths = new ArrayList<String>();
        resourcePaths.add(FEDORA_INTERNAL_PREFIX + resource.getPath());
        List rdfTypes = resource.getTypes();
        effectiveAcl.map(x -> (FedoraResource)x.getRight()).filter(x -> !x.getPath().equals(resource.getPath())).ifPresent(x -> {
            resourcePaths.add(FEDORA_INTERNAL_PREFIX + x.getPath());
            rdfTypes.addAll(x.getTypes());
        });
        if (!effectiveAcl.isPresent()) {
            resourcePaths.addAll(this.getAllPathAncestors(resource.getPath()));
        }
        Predicate<WebACAuthorization> checkAccessTo = this.accessTo.apply(resourcePaths);
        Predicate<WebACAuthorization> checkAccessToClass = this.accessToClass.apply(rdfTypes.stream().map(URI::toString).collect(Collectors.toList()));
        List authorizations = effectiveAcl.map(UncheckedFunction.uncheck(x -> this.getAuthorizations(((URI)x.getLeft()).toString()))).orElseGet(() -> this.getDefaultAuthorizations());
        HashMap effectiveRoles = new HashMap();
        authorizations.stream().filter(x -> checkAccessTo.test((WebACAuthorization)x) || checkAccessToClass.test((WebACAuthorization)x)).forEach(x -> Stream.concat(x.getAgents().stream(), this.dereferenceAgentClasses(x.getAgentClasses()).stream()).distinct().forEach(y -> {
            effectiveRoles.putIfAbsent(y, new HashSet());
            ((Set)effectiveRoles.get(y)).addAll(x.getModes().stream().map(URI::toString).collect(Collectors.toList()));
        }));
        LOGGER.debug("Unfiltered ACL: {}", effectiveRoles);
        return effectiveRoles.entrySet().stream().map(x -> new AbstractMap.SimpleEntry(x.getKey(), new ArrayList((Collection)x.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<String> getAllPathAncestors(String path) {
        List<String> segments = Arrays.asList(path.split("/"));
        return IntStream.range(1, segments.size()).boxed().map(x -> "info:fedora/" + String.join((CharSequence)"/", segments.subList(1, (int)x))).collect(Collectors.toList());
    }

    private List<String> dereferenceAgentClasses(Collection<String> agentClasses) {
        Session internalSession = this.sessionFactory.getInternalSession();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(internalSession);
        ArrayList<String> members = new ArrayList<String>();
        agentClasses.stream().distinct().forEach(arg_0 -> this.lambda$dereferenceAgentClasses$21(internalSession, members, (IdentifierConverter)translator, arg_0));
        if (LOGGER.isDebugEnabled() && !agentClasses.isEmpty()) {
            LOGGER.debug("Found {} members in {} agentClass resources", (Object)members.size(), (Object)agentClasses.size());
        }
        return members;
    }

    private Set<String> getAgentMembers(IdentifierConverter<Resource, FedoraResource> translator, FedoraResource resource) {
        HashSet<String> members = new HashSet<String>();
        Model model = ModelFactory.createDefaultModel();
        Predicate<Property> isMember = this.memberTestFromTypes.apply(resource.getTypes());
        resource.getTriples(translator, PropertiesRdfContext.class).filter(p -> isMember.test(model.asStatement(p).getPredicate())).forEachRemaining(t -> {
            if (t.getObject().isURI()) {
                members.add(t.getObject().getURI());
            } else if (t.getObject().isLiteral()) {
                members.add(t.getObject().getLiteralValue().toString());
            }
        });
        return members;
    }

    private List<WebACAuthorization> getAuthorizations(String location) {
        Session internalSession = this.sessionFactory.getInternalSession();
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(internalSession);
        Model model = ModelFactory.createDefaultModel();
        LOGGER.debug("Effective ACL: {}", (Object)location);
        if (location.startsWith(FEDORA_INTERNAL_PREFIX)) {
            FedoraResource resource = (FedoraResource)this.nodeService.find(internalSession, location.substring(FEDORA_INTERNAL_PREFIX.length()));
            resource.getChildren().forEachRemaining(arg_0 -> WebACRolesProvider.lambda$getAuthorizations$29((IdentifierConverter)translator, model, authorizations, arg_0));
        }
        return authorizations;
    }

    private static WebACAuthorization createAuthorizationFromMap(Map<String, List<String>> data) {
        return new WebACAuthorization((Collection<String>)data.getOrDefault("http://www.w3.org/ns/auth/acl#agent", EMPTY), (Collection<String>)data.getOrDefault("http://www.w3.org/ns/auth/acl#agentClass", EMPTY), data.getOrDefault("http://www.w3.org/ns/auth/acl#mode", EMPTY).stream().map(URI::create).collect(Collectors.toList()), (Collection<String>)data.getOrDefault("http://www.w3.org/ns/auth/acl#accessTo", EMPTY), (Collection<String>)data.getOrDefault("http://www.w3.org/ns/auth/acl#accessToClass", EMPTY));
    }

    private static Optional<Pair<URI, FedoraResource>> getEffectiveAcl(FedoraResource resource) {
        try {
            DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(resource.getNode().getSession());
            ArrayList acls = new ArrayList();
            Model model = ModelFactory.createDefaultModel();
            resource.getTriples((IdentifierConverter)translator, PropertiesRdfContext.class).filter(t -> model.asStatement(t).getPredicate().hasURI("http://www.w3.org/ns/auth/acl#accessControl")).filter(t -> t.getObject().isURI()).forEachRemaining(t -> acls.add(t.getObject().getURI()));
            if (!acls.isEmpty()) {
                if (acls.size() > 1) {
                    LOGGER.warn("Found multiple ACLs defined for this node. Using: {}", acls.get(0));
                }
                return Optional.of(Pair.of((Object)URI.create((String)acls.get(0)), (Object)resource));
            }
            if (resource.getNode().getDepth() == 0) {
                LOGGER.debug("No ACLs defined on this node or in parent hierarchy");
                return Optional.empty();
            }
            LOGGER.trace("Checking parent resource for ACL. No ACL found at {}", (Object)resource.getPath());
            return WebACRolesProvider.getEffectiveAcl(resource.getContainer());
        }
        catch (RepositoryException ex) {
            LOGGER.debug("Exception finding effective ACL: {}", (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    private List<WebACAuthorization> getDefaultAuthorizations() {
        HashMap<String, List<String>> aclTriples = new HashMap<String, List<String>>();
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        WebACRolesProvider.getDefaultAcl().listStatements().forEachRemaining(x -> {
            if (isAclPredicate.test(x.getPredicate())) {
                Triple t = x.asTriple();
                aclTriples.putIfAbsent(t.getPredicate().getURI(), new ArrayList());
                if (t.getObject().isURI()) {
                    ((List)aclTriples.get(t.getPredicate().getURI())).add(t.getObject().getURI());
                } else if (t.getObject().isLiteral()) {
                    ((List)aclTriples.get(t.getPredicate().getURI())).add(t.getObject().getLiteralValue().toString());
                }
            }
        });
        authorizations.add(WebACRolesProvider.createAuthorizationFromMap(aclTriples));
        return authorizations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Model getDefaultAcl() {
        String rootAcl = System.getProperty(ROOT_AUTHORIZATION_PROPERTY);
        Model model2 = ModelFactory.createDefaultModel();
        if (rootAcl != null && new File(rootAcl).isFile()) {
            try {
                LOGGER.debug("Getting root authorization from file: {}", (Object)rootAcl);
                return model2.read(rootAcl);
            }
            catch (JenaException ex) {
                LOGGER.error("Error parsing root authorization file: {}", (Object)ex.getMessage());
            }
        }
        try (InputStream is = WebACRolesProvider.class.getResourceAsStream(ROOT_AUTHORIZATION_LOCATION);){
            LOGGER.debug("Getting root authorization from classpath: {}", (Object)ROOT_AUTHORIZATION_LOCATION);
            Model model = model2.read(is, null, Lang.TTL.getName());
            return model;
        }
        catch (IOException ex) {
            LOGGER.error("Error reading root authorization file: {}", (Object)ex.getMessage());
            return ModelFactory.createDefaultModel();
        }
        catch (JenaException ex) {
            LOGGER.error("Error parsing root authorization file: {}", (Object)ex.getMessage());
        }
        return ModelFactory.createDefaultModel();
    }

    private static /* synthetic */ void lambda$getAuthorizations$29(IdentifierConverter translator, Model model, List authorizations, FedoraResource child) {
        if (child.getTypes().contains(URIConstants.WEBAC_AUTHORIZATION)) {
            HashMap<String, List<String>> aclTriples = new HashMap<String, List<String>>();
            child.getTriples(translator, PropertiesRdfContext.class).filter(p -> isAclPredicate.test(model.asStatement(p).getPredicate())).forEachRemaining(t -> {
                aclTriples.putIfAbsent(t.getPredicate().getURI(), new ArrayList());
                if (t.getObject().isURI()) {
                    ((List)aclTriples.get(t.getPredicate().getURI())).add(StringUtils.substringBeforeLast((String)t.getObject().getURI(), (String)"/jcr:content"));
                } else if (t.getObject().isLiteral()) {
                    ((List)aclTriples.get(t.getPredicate().getURI())).add(t.getObject().getLiteralValue().toString());
                }
            });
            LOGGER.debug("Adding acl:Authorization from {}", (Object)child.getPath());
            authorizations.add(WebACRolesProvider.createAuthorizationFromMap(aclTriples));
        }
    }

    private /* synthetic */ void lambda$dereferenceAgentClasses$21(Session internalSession, List members, IdentifierConverter translator, String x) {
        if (x.startsWith(FEDORA_INTERNAL_PREFIX)) {
            FedoraResource resource = (FedoraResource)this.nodeService.find(internalSession, x.substring(FEDORA_INTERNAL_PREFIX.length()));
            members.addAll(this.getAgentMembers((IdentifierConverter<Resource, FedoraResource>)translator, resource));
        } else if (x.equals("http://xmlns.com/foaf/0.1/Agent")) {
            members.add(x);
        } else {
            LOGGER.info("Ignoring agentClass: {}", (Object)x);
        }
    }
}

