/*
 * Copyright 2015 DuraSpace, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.fcrepo.auth.webac;

import java.net.URI;

import org.fcrepo.kernel.api.models.FedoraResource;

/**
 * A simple class connecting an {@link URI} pointing to an ACL to a {@link FedoraResource} that points to that ACL.
 *
 * @author ajs6f
 */
public class ACLHandle {

    public final URI uri;

    public final FedoraResource resource;

    /**
     * Default constructor.
     *
     * @param uri the URI pointing to an ACL
     * @param resource the requested FedoraResource
     */
    public ACLHandle(final URI uri, final FedoraResource resource) {
        this.uri = uri;
        this.resource = resource;
    }

}
