/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.fcrepo.auth.webac.ACLHandle;
import org.fcrepo.auth.webac.WebACRolesProvider;
import org.fcrepo.http.commons.api.UriAwareHttpHeaderFactory;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.RdfCollectors;
import org.fcrepo.kernel.api.RequiredRdfContext;
import org.fcrepo.kernel.api.TripleCategory;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.NodeService;
import org.fcrepo.kernel.modeshape.FedoraSessionImpl;
import org.fcrepo.kernel.modeshape.rdf.impl.DefaultIdentifierTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LinkHeaderProvider
implements UriAwareHttpHeaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkHeaderProvider.class);
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private NodeService nodeService;

    public Multimap<String, String> createHttpHeadersForResource(UriInfo uriInfo, FedoraResource resource) {
        FedoraSession internalSession = this.sessionFactory.getInternalSession();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(FedoraSessionImpl.getJcrSession((FedoraSession)internalSession));
        ArrayListMultimap headers = ArrayListMultimap.create();
        LOGGER.debug("Adding WebAC Link Header for Resource: {}", (Object)resource.getPath());
        WebACRolesProvider.getEffectiveAcl(resource).ifPresent(arg_0 -> this.lambda$createHttpHeadersForResource$1(internalSession, (IdentifierConverter)translator, uriInfo, (ListMultimap)headers, arg_0));
        return headers;
    }

    private /* synthetic */ void lambda$createHttpHeadersForResource$1(FedoraSession internalSession, IdentifierConverter translator, UriInfo uriInfo, ListMultimap headers, ACLHandle acls) {
        ((Model)((FedoraResource)this.nodeService.find(internalSession, acls.resource.getPath())).getTriples(translator, (TripleCategory)RequiredRdfContext.PROPERTIES).collect(RdfCollectors.toModel())).listObjectsOfProperty(ResourceFactory.createProperty((String)"http://www.w3.org/ns/auth/acl#accessControl")).forEachRemaining(linkObj -> {
            if (linkObj.isURIResource()) {
                Resource acl = linkObj.asResource();
                String aclPath = ((FedoraResource)translator.convert((Object)acl)).getPath();
                URI aclUri = uriInfo.getBaseUriBuilder().path(aclPath).build(new Object[0]);
                headers.put((Object)"Link", (Object)Link.fromUri((URI)aclUri).rel("acl").build(new Object[0]).toString());
            }
        });
    }
}

