/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.shared.JenaException;
import org.fcrepo.auth.roles.common.AccessRolesProvider;
import org.fcrepo.auth.webac.ACLHandle;
import org.fcrepo.auth.webac.URIConstants;
import org.fcrepo.auth.webac.WebACAuthorization;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.RequiredRdfContext;
import org.fcrepo.kernel.api.TripleCategory;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.api.services.NodeService;
import org.fcrepo.kernel.modeshape.FedoraSessionImpl;
import org.fcrepo.kernel.modeshape.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.modeshape.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.modeshape.utils.FedoraTypesUtils;
import org.modeshape.jcr.value.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebACRolesProvider
implements AccessRolesProvider {
    public static final String ROOT_AUTHORIZATION_PROPERTY = "fcrepo.auth.webac.authorization";
    public static final String GROUP_AGENT_BASE_URI_PROPERTY = "fcrepo.auth.webac.groupAgent.baseUri";
    public static final String USER_AGENT_BASE_URI_PROPERTY = "fcrepo.auth.webac.userAgent.baseUri";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebACRolesProvider.class);
    private static final String FEDORA_INTERNAL_PREFIX = "info:fedora";
    private static final String ROOT_AUTHORIZATION_LOCATION = "/root-authorization.ttl";
    private static final String JCR_VERSIONABLE_UUID_PROPERTY = "jcr:versionableUuid";
    @Inject
    private NodeService nodeService;
    @Inject
    private SessionFactory sessionFactory;
    private static final Function<List<String>, Predicate<WebACAuthorization>> accessToClass = uris -> auth -> uris.stream().anyMatch(uri -> auth.getAccessToClassURIs().contains(uri));
    private static final Function<List<String>, Predicate<WebACAuthorization>> accessTo = uris -> auth -> uris.stream().anyMatch(uri -> auth.getAccessToURIs().contains(uri));
    private static final Function<List<URI>, Predicate<Triple>> memberTestFromTypes = types -> triple -> types.contains(URIConstants.FOAF_GROUP) && triple.predicateMatches(NodeFactory.createURI((String)"http://xmlns.com/foaf/0.1/member"));
    private static final Predicate<Triple> hasAclPredicate = triple -> triple.getPredicate().getNameSpace().equals("http://www.w3.org/ns/auth/acl#");

    public void postRoles(javax.jcr.Node node, Map<String, Set<String>> data) throws RepositoryException {
        throw new UnsupportedOperationException("postRoles() is not implemented");
    }

    public void deleteRoles(javax.jcr.Node node) throws RepositoryException {
        throw new UnsupportedOperationException("deleteRoles() is not implemented");
    }

    public Map<String, Collection<String>> findRolesForPath(Path absPath, Session session) throws RepositoryException {
        return this.getAgentRoles(this.locateResource(absPath, (FedoraSession)new FedoraSessionImpl(session)));
    }

    private FedoraResource locateResource(Path path, FedoraSession session) {
        try {
            if (FedoraSessionImpl.getJcrSession((FedoraSession)session).nodeExists(path.toString()) || path.isRoot()) {
                LOGGER.debug("findRolesForPath: {}", (Object)path.getString());
                FedoraResource resource = (FedoraResource)this.nodeService.find(session, path.toString());
                if (resource.hasType("nt:version")) {
                    LOGGER.debug("{} is a version, getting the baseVersion", (Object)resource);
                    return this.getBaseVersion(resource);
                }
                return resource;
            }
        }
        catch (RepositoryException ex) {
            throw new RepositoryRuntimeException((Throwable)ex);
        }
        LOGGER.trace("Path: {} does not exist, checking parent", (Object)path.getString());
        return this.locateResource(path.getParent(), session);
    }

    private FedoraResource getBaseVersion(FedoraResource resource) {
        FedoraSession internalSession = this.sessionFactory.getInternalSession();
        try {
            VersionHistory base = ((Version)FedoraTypesUtils.getJcrNode((FedoraResource)resource)).getContainingHistory();
            if (base.hasProperty(JCR_VERSIONABLE_UUID_PROPERTY)) {
                String versionUuid = base.getProperty(JCR_VERSIONABLE_UUID_PROPERTY).getValue().getString();
                LOGGER.debug("versionableUuid : {}", (Object)versionUuid);
                return (FedoraResource)this.nodeService.find(internalSession, FedoraSessionImpl.getJcrSession((FedoraSession)internalSession).getNodeByIdentifier(versionUuid).getPath());
            }
        }
        catch (ItemNotFoundException e) {
            LOGGER.error("Node with jcr:versionableUuid not found : {}", (Object)e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
        return resource;
    }

    public Map<String, Collection<String>> getRoles(javax.jcr.Node node, boolean effective) {
        try {
            return this.getAgentRoles((FedoraResource)this.nodeService.find((FedoraSession)new FedoraSessionImpl(node.getSession()), node.getPath()));
        }
        catch (RepositoryException ex) {
            throw new RepositoryRuntimeException((Throwable)ex);
        }
    }

    private Map<String, Collection<String>> getAgentRoles(FedoraResource resource) {
        LOGGER.debug("Getting agent roles for: {}", (Object)resource.getPath());
        Optional<ACLHandle> effectiveAcl = WebACRolesProvider.getEffectiveAcl(FedoraTypesUtils.isNonRdfSourceDescription.test(FedoraTypesUtils.getJcrNode((FedoraResource)resource)) ? ((NonRdfSourceDescription)NodeResourceConverter.nodeConverter.convert((Object)FedoraTypesUtils.getJcrNode((FedoraResource)resource))).getDescribedResource() : resource);
        ArrayList<String> resourcePaths = new ArrayList<String>();
        resourcePaths.add(FEDORA_INTERNAL_PREFIX + resource.getPath());
        List rdfTypes = resource.getTypes();
        effectiveAcl.map(aclHandle -> aclHandle.resource).filter(effectiveResource -> !effectiveResource.getPath().equals(resource.getPath())).ifPresent(effectiveResource -> {
            resourcePaths.add(FEDORA_INTERNAL_PREFIX + effectiveResource.getPath());
            rdfTypes.addAll(effectiveResource.getTypes());
        });
        if (!effectiveAcl.isPresent()) {
            resourcePaths.addAll(WebACRolesProvider.getAllPathAncestors(resource.getPath()));
        }
        Predicate<WebACAuthorization> checkAccessTo = accessTo.apply(resourcePaths);
        Predicate<WebACAuthorization> checkAccessToClass = accessToClass.apply(rdfTypes.stream().map(URI::toString).collect(Collectors.toList()));
        List authorizations = effectiveAcl.map(auth -> this.getAuthorizations(auth.uri.toString())).orElseGet(() -> WebACRolesProvider.getDefaultAuthorizations());
        HashMap<String, Collection<String>> effectiveRoles = new HashMap<String, Collection<String>>();
        authorizations.stream().filter(checkAccessTo.or(checkAccessToClass)).forEach(auth -> Stream.concat(auth.getAgents().stream(), this.dereferenceAgentClasses(auth.getAgentClasses()).stream()).forEach(agent -> effectiveRoles.computeIfAbsent((String)agent, key -> new HashSet()).addAll(auth.getModes().stream().map(URI::toString).collect(Collectors.toSet()))));
        LOGGER.debug("Unfiltered ACL: {}", effectiveRoles);
        return effectiveRoles;
    }

    private static List<String> getAllPathAncestors(String path) {
        List<String> segments = Arrays.asList(path.split("/"));
        return IntStream.range(1, segments.size()).mapToObj(frameSize -> "info:fedora/" + String.join((CharSequence)"/", segments.subList(1, frameSize))).collect(Collectors.toList());
    }

    private List<String> dereferenceAgentClasses(Collection<String> agentClasses) {
        FedoraSession internalSession = this.sessionFactory.getInternalSession();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(FedoraSessionImpl.getJcrSession((FedoraSession)internalSession));
        List<String> members = agentClasses.stream().flatMap(arg_0 -> this.lambda$dereferenceAgentClasses$15(internalSession, (IdentifierConverter)translator, arg_0)).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled() && !agentClasses.isEmpty()) {
            LOGGER.debug("Found {} members in {} agentClass resources", (Object)members.size(), (Object)agentClasses.size());
        }
        return members;
    }

    private static Stream<String> getAgentMembers(IdentifierConverter<Resource, FedoraResource> translator, FedoraResource resource) {
        return resource.getTriples(translator, (TripleCategory)RequiredRdfContext.PROPERTIES).filter(memberTestFromTypes.apply(resource.getTypes())).map(Triple::getObject).flatMap(WebACRolesProvider::nodeToStringStream);
    }

    private static final Stream<String> nodeToStringStream(Node object) {
        if (object.isURI()) {
            return Stream.of(object.getURI());
        }
        if (object.isLiteral()) {
            return Stream.of(object.getLiteralValue().toString());
        }
        return Stream.empty();
    }

    private List<WebACAuthorization> getAuthorizations(String location) {
        FedoraSession internalSession = this.sessionFactory.getInternalSession();
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(FedoraSessionImpl.getJcrSession((FedoraSession)internalSession));
        LOGGER.debug("Effective ACL: {}", (Object)location);
        if (location.startsWith(FEDORA_INTERNAL_PREFIX)) {
            FedoraResource resource = (FedoraResource)this.nodeService.find(internalSession, location.substring(FEDORA_INTERNAL_PREFIX.length()));
            resource.getChildren().forEach(arg_0 -> WebACRolesProvider.lambda$getAuthorizations$21((IdentifierConverter)translator, authorizations, arg_0));
        }
        return authorizations;
    }

    private static WebACAuthorization createAuthorizationFromMap(Map<String, List<String>> data) {
        return new WebACAuthorization(data.getOrDefault("http://www.w3.org/ns/auth/acl#agent", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#agentClass", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#mode", Collections.emptyList()).stream().map(URI::create).collect(Collectors.toList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#accessTo", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#accessToClass", Collections.emptyList()));
    }

    static Optional<ACLHandle> getEffectiveAcl(FedoraResource resource) {
        try {
            DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(FedoraTypesUtils.getJcrNode((FedoraResource)resource).getSession());
            List acls = resource.getTriples((IdentifierConverter)translator, (TripleCategory)RequiredRdfContext.PROPERTIES).filter(triple -> triple.getPredicate().equals((Object)NodeFactory.createURI((String)"http://www.w3.org/ns/auth/acl#accessControl"))).map(triple -> {
                if (triple.getObject().isURI()) {
                    return triple.getObject().getURI();
                }
                String error = String.format("The value %s of the %s on this resource must be a URI", triple.getObject(), "http://www.w3.org/ns/auth/acl#accessControl");
                LOGGER.error(error);
                throw new MalformedRdfException(error);
            }).collect(Collectors.toList());
            if (!acls.isEmpty()) {
                if (acls.size() > 1) {
                    LOGGER.warn("Found multiple ACLs defined for this node. Using: {}", acls.get(0));
                }
                return Optional.of(new ACLHandle(URI.create((String)acls.get(0)), resource));
            }
            if (FedoraTypesUtils.getJcrNode((FedoraResource)resource).getDepth() == 0) {
                LOGGER.debug("No ACLs defined on this node or in parent hierarchy");
                return Optional.empty();
            }
            LOGGER.trace("Checking parent resource for ACL. No ACL found at {}", (Object)resource.getPath());
            return WebACRolesProvider.getEffectiveAcl(resource.getContainer());
        }
        catch (RepositoryException ex) {
            LOGGER.debug("Exception finding effective ACL: {}", (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    private static List<WebACAuthorization> getDefaultAuthorizations() {
        HashMap<String, List<String>> aclTriples = new HashMap<String, List<String>>();
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        WebACRolesProvider.getDefaultAcl().listStatements().mapWith(FrontsTriple::asTriple).forEachRemaining(triple -> {
            if (hasAclPredicate.test((Triple)triple)) {
                String predicate = triple.getPredicate().getURI();
                List values = aclTriples.computeIfAbsent(predicate, key -> new ArrayList());
                WebACRolesProvider.nodeToStringStream(triple.getObject()).forEach(values::add);
                if (predicate.equals("http://www.w3.org/ns/auth/acl#agent")) {
                    WebACRolesProvider.additionalAgentValues(triple.getObject()).forEach(values::add);
                }
            }
        });
        authorizations.add(WebACRolesProvider.createAuthorizationFromMap(aclTriples));
        return authorizations;
    }

    private static Stream<String> additionalAgentValues(Node object) {
        String groupBaseUri = System.getProperty(GROUP_AGENT_BASE_URI_PROPERTY);
        String userBaseUri = System.getProperty(USER_AGENT_BASE_URI_PROPERTY);
        if (object.isURI()) {
            String uri = object.getURI();
            if (userBaseUri != null && uri.startsWith(userBaseUri)) {
                return Stream.of(uri.substring(userBaseUri.length()));
            }
            if (groupBaseUri != null && uri.startsWith(groupBaseUri)) {
                return Stream.of(uri.substring(groupBaseUri.length()));
            }
        }
        return Stream.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Model getDefaultAcl() {
        String rootAcl = System.getProperty(ROOT_AUTHORIZATION_PROPERTY);
        Model model2 = ModelFactory.createDefaultModel();
        if (rootAcl != null && new File(rootAcl).isFile()) {
            try {
                LOGGER.debug("Getting root authorization from file: {}", (Object)rootAcl);
                return model2.read(rootAcl);
            }
            catch (JenaException ex) {
                LOGGER.error("Error parsing root authorization file: {}", (Object)ex.getMessage());
            }
        }
        try (InputStream is = WebACRolesProvider.class.getResourceAsStream(ROOT_AUTHORIZATION_LOCATION);){
            LOGGER.debug("Getting root authorization from classpath: {}", (Object)ROOT_AUTHORIZATION_LOCATION);
            Model model = model2.read(is, null, Lang.TTL.getName());
            return model;
        }
        catch (IOException ex) {
            LOGGER.error("Error reading root authorization file: {}", (Object)ex.getMessage());
            return ModelFactory.createDefaultModel();
        }
        catch (JenaException ex) {
            LOGGER.error("Error parsing root authorization file: {}", (Object)ex.getMessage());
        }
        return ModelFactory.createDefaultModel();
    }

    private static /* synthetic */ void lambda$getAuthorizations$21(IdentifierConverter translator, List authorizations, FedoraResource child) {
        if (child.getTypes().contains(URIConstants.WEBAC_AUTHORIZATION)) {
            HashMap<String, List<String>> aclTriples = new HashMap<String, List<String>>();
            child.getTriples(translator, (TripleCategory)RequiredRdfContext.PROPERTIES).filter(hasAclPredicate).forEach(triple -> {
                String predicate = triple.getPredicate().getURI();
                List values = aclTriples.computeIfAbsent(predicate, key -> new ArrayList());
                WebACRolesProvider.nodeToStringStream(triple.getObject()).forEach(values::add);
                if (predicate.equals("http://www.w3.org/ns/auth/acl#agent")) {
                    WebACRolesProvider.additionalAgentValues(triple.getObject()).forEach(values::add);
                }
            });
            LOGGER.debug("Adding acl:Authorization from {}", (Object)child.getPath());
            authorizations.add(WebACRolesProvider.createAuthorizationFromMap(aclTriples));
        }
    }

    private /* synthetic */ Stream lambda$dereferenceAgentClasses$15(FedoraSession internalSession, IdentifierConverter translator, String agentClass) {
        if (agentClass.startsWith(FEDORA_INTERNAL_PREFIX)) {
            FedoraResource resource = (FedoraResource)this.nodeService.find(internalSession, agentClass.substring(FEDORA_INTERNAL_PREFIX.length()));
            return WebACRolesProvider.getAgentMembers((IdentifierConverter<Resource, FedoraResource>)translator, resource);
        }
        if (agentClass.equals("http://xmlns.com/foaf/0.1/Agent")) {
            return Stream.of(agentClass);
        }
        LOGGER.info("Ignoring agentClass: {}", (Object)agentClass);
        return Stream.empty();
    }
}

