/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.common;

import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.persistence.common.ResourceHeadersImpl;

public class ResourceHeaderUtils {
    private ResourceHeaderUtils() {
    }

    public static ResourceHeadersImpl newResourceHeaders(FedoraId parentId, FedoraId fedoraId, String interactionModel) {
        ResourceHeadersImpl headers = new ResourceHeadersImpl();
        headers.setHeadersVersion("1.0");
        headers.setId(fedoraId);
        headers.setParent(parentId);
        headers.setInteractionModel(interactionModel);
        return headers;
    }

    public static void touchCreationHeaders(ResourceHeadersImpl headers, String userPrincipal) {
        ResourceHeaderUtils.touchCreationHeaders(headers, userPrincipal, null);
    }

    public static void touchCreationHeaders(ResourceHeadersImpl headers, String userPrincipal, Instant createdDate) {
        Instant instant;
        if (createdDate == null) {
            ZonedDateTime now = ZonedDateTime.now();
            instant = now.toInstant();
        } else {
            instant = createdDate;
        }
        headers.setCreatedDate(instant);
        headers.setCreatedBy(userPrincipal);
        headers.setMementoCreatedDate(instant);
    }

    public static void touchModificationHeaders(ResourceHeadersImpl headers, String userPrincipal) {
        ResourceHeaderUtils.touchModificationHeaders(headers, userPrincipal, null);
    }

    public static void touchModificationHeaders(ResourceHeadersImpl headers, String userPrincipal, Instant modifiedDate) {
        Instant instant;
        if (modifiedDate == null) {
            ZonedDateTime now = ZonedDateTime.now();
            instant = now.toInstant();
        } else {
            instant = modifiedDate;
        }
        headers.setLastModifiedDate(instant);
        headers.setLastModifiedBy(userPrincipal);
        ResourceHeaderUtils.touchMementoCreateHeaders(headers, instant);
        String stateToken = DigestUtils.md5Hex((String)String.valueOf(instant.toEpochMilli())).toUpperCase();
        headers.setStateToken(stateToken);
    }

    public static void touchMementoCreateHeaders(ResourceHeadersImpl headers, Instant versionDate) {
        Instant instant;
        if (versionDate == null) {
            ZonedDateTime now = ZonedDateTime.now();
            instant = now.toInstant();
        } else {
            instant = versionDate;
        }
        headers.setMementoCreatedDate(instant);
    }

    public static void touchMementoCreateHeaders(ResourceHeadersImpl headers) {
        ResourceHeaderUtils.touchMementoCreateHeaders(headers, null);
    }

    public static void populateBinaryHeaders(ResourceHeadersImpl headers, String mimetype, String filename, long filesize, Collection<URI> digests) {
        headers.setMimeType(mimetype);
        headers.setDigests(digests);
        headers.setFilename(filename);
        headers.setContentSize(filesize);
    }

    public static void populateExternalBinaryHeaders(ResourceHeadersImpl headers, String externalUrl, String externalHandling) {
        headers.setExternalHandling(externalHandling);
        headers.setExternalUrl(externalUrl);
    }
}

