/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.fcrepo.config.DigestAlgorithm;
import org.fcrepo.kernel.api.exception.InvalidChecksumException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.persistence.common.MultiDigestInputStreamWrapper;
import org.junit.Assert;
import org.junit.Test;

public class MultiDigestInputStreamWrapperTest {
    private static final String CONTENT = "Something to digest";
    private static final String MD5 = "7afbf05666feeebe7fbbf1c9071584e6";
    private static final URI MD5_URI = URI.create("urn:md5:7afbf05666feeebe7fbbf1c9071584e6");
    private static final String SHA1 = "23d51c61a578a8cb00c5eec6b29c12b7da15c8de";
    private static final URI SHA1_URI = URI.create("urn:sha1:23d51c61a578a8cb00c5eec6b29c12b7da15c8de");
    private static final String SHA512 = "051c93c9cfd1b0a238c858267789fddb4fd1500c957d0ae609ec2fc2c96b3db9edddde5374be73b664056ed6281a842041aa43a87fd4e0fbc1b6890676cead6d";
    private static final URI SHA512_URI = URI.create("urn:sha-512:051c93c9cfd1b0a238c858267789fddb4fd1500c957d0ae609ec2fc2c96b3db9edddde5374be73b664056ed6281a842041aa43a87fd4e0fbc1b6890676cead6d");
    private static final String SHA512256 = "dea93ec79abc429b0065e73995a4fe0ddb7a3ec65f2b14139e75360a8ab66efc";
    private static final URI SHA512256_URI = URI.create("urn:sha-512/256:dea93ec79abc429b0065e73995a4fe0ddb7a3ec65f2b14139e75360a8ab66efc");
    private final InputStream contentStream = new ByteArrayInputStream("Something to digest".getBytes());

    @Test
    public void checkFixity_SingleDigests_Success() throws Exception {
        List<URI> digests = Arrays.asList(SHA1_URI);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, null);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
    }

    @Test
    public void checkFixity_MultiDigests_Success() throws Exception {
        List<URI> digests = Arrays.asList(MD5_URI, SHA1_URI, SHA512_URI, SHA512256_URI);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, null);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
    }

    @Test
    public void checkFixity_NoDigests() throws Exception {
        List digests = Collections.emptyList();
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, null);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
    }

    @Test(expected=InvalidChecksumException.class)
    public void checkFixity_InvalidDigest() throws Exception {
        List<URI> digests = Arrays.asList(MD5_URI, URI.create("urn:sha1:totallybusted"), SHA512_URI);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, null);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void unsupportedDigestAlgorithm() throws Exception {
        List<URI> digests = Arrays.asList(URI.create("urn:yum:123456"), SHA512_URI);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, null);
        wrapper.getInputStream();
    }

    @Test
    public void checkFixity_BeforeRead() throws Exception {
        List<URI> digests = Arrays.asList(MD5_URI);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, null);
        wrapper.checkFixity();
    }

    @Test
    public void checkFixity_OnlyWantDigest() throws Exception {
        List<DigestAlgorithm> wantDigests = Arrays.asList(DigestAlgorithm.SHA1);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, null, wantDigests);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
    }

    @Test
    public void checkFixity_OverlappingWantDigestAndProvided() throws Exception {
        List<URI> digests = Arrays.asList(SHA1_URI);
        List<DigestAlgorithm> wantDigests = Arrays.asList(DigestAlgorithm.SHA1);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, wantDigests);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
    }

    @Test(expected=InvalidChecksumException.class)
    public void checkFixity_OverlappingWantDigestAndProvided_InvalidDigest() throws Exception {
        List<URI> digests = Arrays.asList(URI.create("urn:sha1:totallybusted"));
        List<DigestAlgorithm> wantDigests = Arrays.asList(DigestAlgorithm.SHA1);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, wantDigests);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
    }

    @Test
    public void checkFixity_DifferentWantDigestAndProvided() throws Exception {
        List<URI> digests = Arrays.asList(SHA1_URI);
        List<DigestAlgorithm> wantDigests = Arrays.asList(DigestAlgorithm.MD5);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, wantDigests);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
    }

    @Test
    public void getDigests_FromWantDigests() throws Exception {
        List<DigestAlgorithm> wantDigests = Arrays.asList(DigestAlgorithm.SHA1, DigestAlgorithm.SHA512);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, null, wantDigests);
        List computed = wrapper.getDigests();
        Assert.assertTrue((boolean)computed.contains(SHA1_URI));
        Assert.assertTrue((boolean)computed.contains(SHA512_URI));
    }

    @Test
    public void getDigests_FromProvidedDigests() throws Exception {
        List<URI> digests = Arrays.asList(SHA1_URI, MD5_URI);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, null);
        List computed = wrapper.getDigests();
        Assert.assertTrue((boolean)computed.contains(SHA1_URI));
        Assert.assertTrue((boolean)computed.contains(MD5_URI));
    }

    @Test
    public void getDigests_FromWantDigestsAndProvided() throws Exception {
        List<DigestAlgorithm> wantDigests = Arrays.asList(DigestAlgorithm.SHA1, DigestAlgorithm.SHA512);
        List<URI> digests = Arrays.asList(SHA1_URI, MD5_URI);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, wantDigests);
        List computed = wrapper.getDigests();
        Assert.assertTrue((boolean)computed.contains(SHA1_URI));
        Assert.assertTrue((boolean)computed.contains(SHA512_URI));
        Assert.assertTrue((boolean)computed.contains(MD5_URI));
    }

    @Test
    public void getDigests_AfterCheckFixity() throws Exception {
        List<URI> digests = Arrays.asList(SHA1_URI);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, digests, null);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        wrapper.checkFixity();
        List computed = wrapper.getDigests();
        Assert.assertTrue((boolean)computed.contains(SHA1_URI));
    }

    @Test
    public void getDigests_FromConsumedStream() throws Exception {
        List<DigestAlgorithm> wantDigests = Arrays.asList(DigestAlgorithm.SHA512);
        MultiDigestInputStreamWrapper wrapper = new MultiDigestInputStreamWrapper(this.contentStream, null, wantDigests);
        IOUtils.toString((InputStream)wrapper.getInputStream(), (Charset)StandardCharsets.UTF_8);
        List computed = wrapper.getDigests();
        Assert.assertTrue((boolean)computed.contains(SHA512_URI));
    }
}

