/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.config.DigestAlgorithm;
import org.fcrepo.kernel.api.exception.InvalidChecksumException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.exception.UnsupportedAlgorithmException;
import org.fcrepo.kernel.api.utils.ContentDigest;

public class MultiDigestInputStreamWrapper {
    private static final int BUFFER_SIZE = 8192;
    private final InputStream sourceStream;
    private final Map<String, String> algToDigest;
    private final Map<String, DigestInputStream> algToDigestStream;
    private boolean streamRetrieved;
    private Map<String, String> computedDigests;

    public MultiDigestInputStreamWrapper(InputStream sourceStream, Collection<URI> digests, Collection<DigestAlgorithm> wantDigests) {
        this.sourceStream = sourceStream;
        this.algToDigest = new HashMap<String, String>();
        this.algToDigestStream = new HashMap<String, DigestInputStream>();
        if (digests != null) {
            for (URI digestUri : digests) {
                String algorithm = ContentDigest.getAlgorithm((URI)digestUri);
                String hash = StringUtils.substringAfterLast((String)digestUri.toString(), (String)":");
                this.algToDigest.put(algorithm, hash);
            }
        }
        if (wantDigests != null) {
            for (DigestAlgorithm wantDigest : wantDigests) {
                if (this.algToDigest.containsKey(wantDigest.getAlgorithm())) continue;
                this.algToDigest.put(wantDigest.getAlgorithm(), null);
            }
        }
    }

    public InputStream getInputStream() {
        this.streamRetrieved = true;
        InputStream digestStream = this.sourceStream;
        for (String algorithm : this.algToDigest.keySet()) {
            try {
                digestStream = new DigestInputStream(digestStream, MessageDigest.getInstance(algorithm));
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedAlgorithmException("Unsupported digest algorithm: " + algorithm, (Throwable)e);
            }
            this.algToDigestStream.put(algorithm, (DigestInputStream)digestStream);
        }
        return digestStream;
    }

    public void checkFixity() throws InvalidChecksumException {
        this.calculateDigests();
        this.algToDigest.forEach((algorithm, originalDigest) -> {
            if (originalDigest == null) {
                return;
            }
            String computed = this.computedDigests.get(algorithm);
            if (!originalDigest.equalsIgnoreCase(computed)) {
                throw new InvalidChecksumException(String.format("Checksum mismatch, computed %s digest %s did not match expected value %s", algorithm, computed, originalDigest));
            }
        });
    }

    public List<URI> getDigests() {
        this.calculateDigests();
        return this.computedDigests.entrySet().stream().map(e -> ContentDigest.asURI((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toList());
    }

    public String getDigest(DigestAlgorithm alg) {
        this.calculateDigests();
        return this.computedDigests.entrySet().stream().filter(entry -> alg.getAlgorithm().equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private void calculateDigests() {
        if (this.computedDigests != null) {
            return;
        }
        if (!this.streamRetrieved) {
            byte[] buffer = new byte[8192];
            try (InputStream is = this.getInputStream();){
                while (is.read(buffer) != -1) {
                }
            }
            catch (IOException e) {
                throw new RepositoryRuntimeException("Failed to read content stream while calculating digests", (Throwable)e);
            }
        }
        this.computedDigests = new HashMap<String, String>();
        this.algToDigestStream.forEach((algorithm, digestStream) -> {
            String computed = Hex.encodeHexString((byte[])digestStream.getMessageDigest().digest());
            this.computedDigests.put((String)algorithm, computed);
        });
    }
}

