/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl;

import javax.inject.Inject;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.config.OcflPropsConfig;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.CreateRdfSourceOperation;
import org.fcrepo.kernel.api.operations.RdfSourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.VersionResourceOperationFactory;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.IndexBuilder;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class RepositoryInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryInitializer.class);
    @Inject
    private OcflPersistentSessionManager sessionManager;
    @Inject
    private RdfSourceOperationFactory operationFactory;
    @Inject
    private IndexBuilder indexBuilder;
    @Inject
    private VersionResourceOperationFactory versionResourceOperationFactory;
    @Inject
    private OcflPropsConfig config;
    @Inject
    private FedoraPropsConfig fedoraPropsConfig;
    @Inject
    private TransactionManager txManager;

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            this.initialize();
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize repository", (Throwable)e);
            ((ConfigurableApplicationContext)event.getApplicationContext()).close();
        }
    }

    public void initialize() {
        LOGGER.info("Initializing repository");
        this.indexBuilder.rebuildIfNecessary();
        FedoraId root = FedoraId.getRepositoryRootId();
        try {
            Transaction transaction = this.txManager.create();
            transaction.setShortLived(true);
            PersistentStorageSession session = this.sessionManager.getSession(transaction);
            try {
                session.getHeaders(root, null);
            }
            catch (PersistentItemNotFoundException e) {
                LOGGER.debug("Repository root ({}) not found. Creating...", (Object)root);
                CreateRdfSourceOperation operation = this.operationFactory.createBuilder(transaction, root, RdfLexicon.BASIC_CONTAINER.getURI(), this.fedoraPropsConfig.getServerManagedPropsMode()).parentId(root).build();
                session.persist((ResourceOperation)operation);
                if (!this.config.isAutoVersioningEnabled()) {
                    ResourceOperation versionOperation = this.versionResourceOperationFactory.createBuilder(transaction, root).build();
                    session.persist(versionOperation);
                }
                transaction.commit();
                LOGGER.debug("Successfully created repository root ({}).", (Object)root);
            }
        }
        catch (PersistentStorageException ex) {
            throw new RepositoryRuntimeException(ex.getMessage(), (Throwable)ex);
        }
    }
}

