/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.operations.CreateResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.common.ResourceHeaderUtils;
import org.fcrepo.persistence.common.ResourceHeadersImpl;
import org.fcrepo.persistence.ocfl.api.FedoraOcflMappingNotFoundException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.api.Persister;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.persistence.ocfl.impl.ResourceHeadersAdapter;
import org.fcrepo.storage.ocfl.OcflObjectSession;

abstract class AbstractPersister
implements Persister {
    private final Class<? extends ResourceOperation> resourceOperationClass;
    private final ResourceOperationType resourceOperationType;
    protected final FedoraToOcflObjectIndex ocflIndex;

    protected AbstractPersister(Class<? extends ResourceOperation> resourceOperationClass, ResourceOperationType resourceOperationType, FedoraToOcflObjectIndex ocflIndex) {
        this.resourceOperationClass = resourceOperationClass;
        this.resourceOperationType = resourceOperationType;
        this.ocflIndex = ocflIndex;
    }

    @Override
    public boolean handle(ResourceOperation operation) {
        return this.resourceOperationClass.isInstance(operation) && this.resourceOperationType.equals((Object)operation.getType());
    }

    protected FedoraOcflMapping getMapping(Transaction transaction, FedoraId resourceId) throws PersistentStorageException {
        try {
            return this.ocflIndex.getMapping(transaction, resourceId);
        }
        catch (FedoraOcflMappingNotFoundException e) {
            throw new PersistentStorageException(e.getMessage());
        }
    }

    protected Optional<FedoraId> findArchivalGroupInAncestry(FedoraId fedoraId, OcflPersistentStorageSession session) {
        if (fedoraId.isRepositoryRoot()) {
            return Optional.empty();
        }
        String resourceId = fedoraId.getResourceId();
        try {
            ResourceHeaders headers = session.getHeaders(fedoraId.asResourceId(), null);
            if (headers != null && headers.isArchivalGroup()) {
                return Optional.of(fedoraId);
            }
        }
        catch (PersistentItemNotFoundException headers) {
        }
        catch (PersistentStorageException ex) {
            throw new RepositoryRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        String parentId = resourceId.substring(0, resourceId.lastIndexOf(47));
        return this.findArchivalGroupInAncestry(FedoraId.create((String[])new String[]{parentId}), session);
    }

    protected String mapToOcflId(Transaction transaction, FedoraId fedoraId) {
        try {
            FedoraOcflMapping mapping = this.ocflIndex.getMapping(transaction, fedoraId.asBaseId());
            return mapping.getOcflObjectId();
        }
        catch (FedoraOcflMappingNotFoundException e) {
            return fedoraId.getBaseId();
        }
    }

    protected ResourceHeadersImpl createCommonHeaders(OcflObjectSession session, ResourceOperation operation, boolean isResourceRoot, FedoraId archivalGroupId) throws PersistentStorageException {
        ResourceHeadersImpl headers;
        Instant now = Instant.now();
        if (ResourceOperationType.CREATE.equals((Object)operation.getType())) {
            CreateResourceOperation createOperation = (CreateResourceOperation)operation;
            headers = ResourceHeaderUtils.newResourceHeaders((FedoraId)createOperation.getParentId(), (FedoraId)createOperation.getResourceId(), (String)createOperation.getInteractionModel());
            ResourceHeaderUtils.touchCreationHeaders((ResourceHeadersImpl)headers, (String)createOperation.getUserPrincipal(), (Instant)now);
            headers.setArchivalGroup(createOperation.isArchivalGroup());
            headers.setObjectRoot(isResourceRoot);
            headers.setArchivalGroupId(archivalGroupId);
        } else {
            headers = new ResourceHeadersAdapter(session.readHeaders(operation.getResourceId().getResourceId())).asKernelHeaders();
        }
        headers.setDigests(new ArrayList());
        headers.setContentSize(-1L);
        ResourceHeaderUtils.touchModificationHeaders((ResourceHeadersImpl)headers, (String)operation.getUserPrincipal(), (Instant)now);
        return headers;
    }
}

