/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.util.Optional;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.CreateResourceOperation;
import org.fcrepo.kernel.api.operations.RdfSourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentItemConflictException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateRdfSourcePersister
extends AbstractRdfSourcePersister {
    private static final Logger log = LoggerFactory.getLogger(CreateRdfSourcePersister.class);

    protected CreateRdfSourcePersister(FedoraToOcflObjectIndex index) {
        super(RdfSourceOperation.class, ResourceOperationType.CREATE, index);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        FedoraId rootObjectId;
        FedoraId resourceId = operation.getResourceId();
        log.debug("persisting {} to {}", (Object)resourceId, (Object)session);
        CreateResourceOperation createResourceOp = (CreateResourceOperation)operation;
        boolean archivalGroup = createResourceOp.isArchivalGroup();
        Optional<FedoraId> archivalGroupId = this.findArchivalGroupInAncestry(resourceId, session);
        if (archivalGroup) {
            if (archivalGroupId.isPresent()) {
                throw new PersistentItemConflictException("Nesting an ArchivalGroup within an ArchivalGroup is not permitted");
            }
            rootObjectId = resourceId;
        } else {
            rootObjectId = archivalGroupId.orElseGet(() -> ((FedoraId)resourceId).asBaseId());
        }
        String ocflObjectId = this.mapToOcflId(operation.getTransaction(), rootObjectId);
        OcflObjectSession ocflObjectSession = session.findOrCreateSession(ocflObjectId);
        this.persistRDF(ocflObjectSession, operation, rootObjectId.asBaseId(), archivalGroupId.isPresent());
        this.ocflIndex.addMapping(operation.getTransaction(), resourceId.asResourceId(), rootObjectId.asBaseId(), ocflObjectId);
    }
}

