/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.util.Optional;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.CreateVersionResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentItemConflictException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.common.ResourceHeaderUtils;
import org.fcrepo.persistence.common.ResourceHeadersImpl;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractPersister;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.persistence.ocfl.impl.ResourceHeadersAdapter;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVersionPersister
extends AbstractPersister {
    private static final Logger LOG = LoggerFactory.getLogger(CreateVersionPersister.class);

    protected CreateVersionPersister(FedoraToOcflObjectIndex index) {
        super(CreateVersionResourceOperation.class, ResourceOperationType.UPDATE, index);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        FedoraId resourceId = operation.getResourceId();
        LOG.debug("creating new version of <{}> in session <{}>", (Object)resourceId, (Object)session);
        Optional<FedoraId> archivalGroupId = this.findArchivalGroupInAncestry(resourceId, session);
        if (archivalGroupId.isPresent() && !archivalGroupId.get().equals((Object)resourceId)) {
            throw new PersistentItemConflictException(String.format("Resource <%s> is contained in Archival Group <%s> and cannot be versioned directly. Version the Archival Group instead.", resourceId, archivalGroupId));
        }
        FedoraOcflMapping ocflMapping = this.getMapping(operation.getTransaction(), resourceId);
        OcflObjectSession ocflObjectSession = session.findOrCreateSession(ocflMapping.getOcflObjectId());
        ResourceHeadersImpl headers = new ResourceHeadersAdapter(ocflObjectSession.readHeaders(resourceId.getResourceId())).asKernelHeaders();
        ResourceHeaderUtils.touchMementoCreateHeaders((ResourceHeadersImpl)headers);
        ocflObjectSession.writeHeaders(new ResourceHeadersAdapter(headers).asStorageHeaders());
        ocflObjectSession.commitType(CommitType.NEW_VERSION);
    }
}

