/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import org.fcrepo.kernel.api.operations.ReindexResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.Persister;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.persistence.ocfl.impl.ReindexService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReindexResourcePersister
implements Persister {
    private static final Logger log = LoggerFactory.getLogger(ReindexResourcePersister.class);
    private ReindexService reindexService;

    protected ReindexResourcePersister(ReindexService reindexService) {
        this.reindexService = reindexService;
    }

    @Override
    public boolean handle(ResourceOperation operation) {
        return operation != null && ResourceOperationType.REINDEX.equals((Object)operation.getType());
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        String ocflId = operation.getResourceId().getBaseId();
        ReindexResourceOperation reindexOp = (ReindexResourceOperation)operation;
        try {
            this.reindexService.indexOcflObject(reindexOp.getTransaction(), ocflId);
        }
        catch (Exception ex) {
            throw new PersistentStorageException(ex.getMessage(), (Throwable)ex);
        }
    }
}

