/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.util.Optional;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractNonRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateNonRdfSourcePersister
extends AbstractNonRdfSourcePersister {
    private static final Logger log = LoggerFactory.getLogger(CreateNonRdfSourcePersister.class);

    protected CreateNonRdfSourcePersister(FedoraToOcflObjectIndex index) {
        super(NonRdfSourceOperation.class, ResourceOperationType.CREATE, index);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        FedoraId resourceId = operation.getResourceId();
        log.debug("persisting {} to {}", (Object)resourceId, (Object)session);
        Optional<FedoraId> archivalGroupId = this.findArchivalGroupInAncestry(resourceId, session);
        FedoraId rootObjectId = archivalGroupId.orElseGet(() -> ((FedoraId)resourceId).asBaseId());
        String ocflId = this.mapToOcflId(operation.getTransaction(), rootObjectId);
        OcflObjectSession ocflObjectSession = session.findOrCreateSession(ocflId);
        this.persistNonRDFSource(operation, ocflObjectSession, rootObjectId.asBaseId(), archivalGroupId.isPresent());
        this.ocflIndex.addMapping(operation.getTransaction(), resourceId.asResourceId(), rootObjectId.asBaseId(), ocflId);
    }
}

