/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.common.ResourceHeaderUtils;
import org.fcrepo.persistence.common.ResourceHeadersImpl;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractPersister;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.persistence.ocfl.impl.ResourceHeadersAdapter;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeleteResourcePersister
extends AbstractPersister {
    private static final Logger log = LoggerFactory.getLogger(DeleteResourcePersister.class);

    protected DeleteResourcePersister(FedoraToOcflObjectIndex fedoraOcflIndex) {
        super(ResourceOperation.class, ResourceOperationType.DELETE, fedoraOcflIndex);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        FedoraOcflMapping mapping = this.getMapping(operation.getTransaction(), operation.getResourceId());
        FedoraId resourceId = operation.getResourceId();
        OcflObjectSession objectSession = session.findOrCreateSession(mapping.getOcflObjectId());
        log.debug("Deleting {} from {}", (Object)resourceId, (Object)mapping.getOcflObjectId());
        try {
            ResourceHeadersImpl headers = new ResourceHeadersAdapter(objectSession.readHeaders(resourceId.getResourceId())).asKernelHeaders();
            headers.setDeleted(true);
            ResourceHeaderUtils.touchModificationHeaders((ResourceHeadersImpl)headers, (String)operation.getUserPrincipal());
            objectSession.deleteContentFile(new ResourceHeadersAdapter(headers).asStorageHeaders());
            if (headers.getArchivalGroupId() == null) {
                objectSession.commitType(CommitType.NEW_VERSION);
            }
        }
        catch (RuntimeException e) {
            throw new PersistentStorageException(String.format("Failed to delete resource content for %s", resourceId), (Throwable)e);
        }
        if (!objectSession.containsResource(resourceId.getResourceId())) {
            this.ocflIndex.removeMapping(operation.getTransaction(), resourceId);
        }
    }
}

